/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BoxAPIException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int responseCode;
    private String response;
    private Map<String, List<String>> headers;

    public BoxAPIException(String message) {
        super(message);
        this.responseCode = 0;
        this.response = null;
        this.headers = null;
    }

    public BoxAPIException(String message, int responseCode, String response) {
        super(message + "\n" + response);
        this.responseCode = responseCode;
        this.response = response;
        this.headers = null;
    }

    public BoxAPIException(String message, int responseCode, String responseBody, Map<String, List<String>> responseHeaders) {
        super(message + "\n" + responseBody);
        this.responseCode = responseCode;
        this.response = responseBody;
        this.headers = responseHeaders;
    }

    public BoxAPIException(String message, Throwable cause) {
        super(message, cause);
        this.responseCode = 0;
        this.response = null;
        this.headers = null;
    }

    public BoxAPIException(String message, int responseCode, String response, Throwable cause) {
        super(message, cause);
        this.responseCode = responseCode;
        this.response = response;
        this.headers = null;
    }

    public BoxAPIException(String message, int responseCode, String responseBody, Map<String, List<String>> responseHeaders, Throwable cause) {
        super(message, cause);
        this.responseCode = responseCode;
        this.response = responseBody;
        this.headers = responseHeaders;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponse() {
        return this.response;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers != null) {
            return this.headers;
        }
        return Collections.emptyMap();
    }

    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    protected void setResponse(String response) {
        this.response = response;
    }

    protected void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }
}

