/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.filefull;

import com.box.sdkgen.internal.Nullable;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.file.File;
import com.box.sdkgen.schemas.file.FileItemStatusField;
import com.box.sdkgen.schemas.file.FilePathCollectionField;
import com.box.sdkgen.schemas.file.FileSharedLinkField;
import com.box.sdkgen.schemas.filebase.FileBaseTypeField;
import com.box.sdkgen.schemas.filefull.FileFullAllowedInviteeRolesField;
import com.box.sdkgen.schemas.filefull.FileFullClassificationField;
import com.box.sdkgen.schemas.filefull.FileFullExpiringEmbedLinkField;
import com.box.sdkgen.schemas.filefull.FileFullLockField;
import com.box.sdkgen.schemas.filefull.FileFullMetadataField;
import com.box.sdkgen.schemas.filefull.FileFullPermissionsField;
import com.box.sdkgen.schemas.filefull.FileFullRepresentationsField;
import com.box.sdkgen.schemas.filefull.FileFullSharedLinkPermissionOptionsField;
import com.box.sdkgen.schemas.filefull.FileFullWatermarkInfoField;
import com.box.sdkgen.schemas.fileversionmini.FileVersionMini;
import com.box.sdkgen.schemas.foldermini.FolderMini;
import com.box.sdkgen.schemas.usermini.UserMini;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.box.sdkgen.serialization.json.Valuable;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class FileFull
extends File {
    @JsonProperty(value="version_number")
    protected String versionNumber;
    @JsonProperty(value="comment_count")
    protected Long commentCount;
    protected FileFullPermissionsField permissions;
    protected List<String> tags;
    @Nullable
    protected FileFullLockField lock;
    protected String extension;
    @JsonProperty(value="is_package")
    protected Boolean isPackage;
    @JsonProperty(value="expiring_embed_link")
    protected FileFullExpiringEmbedLinkField expiringEmbedLink;
    @JsonProperty(value="watermark_info")
    protected FileFullWatermarkInfoField watermarkInfo;
    @JsonProperty(value="is_accessible_via_shared_link")
    protected Boolean isAccessibleViaSharedLink;
    @JsonDeserialize(using=AllowedInviteeRolesDeserializer.class)
    @JsonSerialize(using=AllowedInviteeRolesSerializer.class)
    @JsonProperty(value="allowed_invitee_roles")
    protected List<EnumWrapper<FileFullAllowedInviteeRolesField>> allowedInviteeRoles;
    @JsonProperty(value="is_externally_owned")
    protected Boolean isExternallyOwned;
    @JsonProperty(value="has_collaborations")
    protected Boolean hasCollaborations;
    protected FileFullMetadataField metadata;
    @JsonProperty(value="expires_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected Date expiresAt;
    protected FileFullRepresentationsField representations;
    protected FileFullClassificationField classification;
    @JsonProperty(value="uploader_display_name")
    protected String uploaderDisplayName;
    @JsonProperty(value="disposition_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected Date dispositionAt;
    @JsonDeserialize(using=SharedLinkPermissionOptionsDeserializer.class)
    @JsonSerialize(using=SharedLinkPermissionOptionsSerializer.class)
    @JsonProperty(value="shared_link_permission_options")
    @Nullable
    protected List<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> sharedLinkPermissionOptions;
    @JsonProperty(value="is_associated_with_app_item")
    protected Boolean isAssociatedWithAppItem;

    public FileFull(@JsonProperty(value="id") String id) {
        super(id);
    }

    protected FileFull(Builder builder) {
        super(builder);
        this.versionNumber = builder.versionNumber;
        this.commentCount = builder.commentCount;
        this.permissions = builder.permissions;
        this.tags = builder.tags;
        this.lock = builder.lock;
        this.extension = builder.extension;
        this.isPackage = builder.isPackage;
        this.expiringEmbedLink = builder.expiringEmbedLink;
        this.watermarkInfo = builder.watermarkInfo;
        this.isAccessibleViaSharedLink = builder.isAccessibleViaSharedLink;
        this.allowedInviteeRoles = builder.allowedInviteeRoles;
        this.isExternallyOwned = builder.isExternallyOwned;
        this.hasCollaborations = builder.hasCollaborations;
        this.metadata = builder.metadata;
        this.expiresAt = builder.expiresAt;
        this.representations = builder.representations;
        this.classification = builder.classification;
        this.uploaderDisplayName = builder.uploaderDisplayName;
        this.dispositionAt = builder.dispositionAt;
        this.sharedLinkPermissionOptions = builder.sharedLinkPermissionOptions;
        this.isAssociatedWithAppItem = builder.isAssociatedWithAppItem;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public Long getCommentCount() {
        return this.commentCount;
    }

    public FileFullPermissionsField getPermissions() {
        return this.permissions;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public FileFullLockField getLock() {
        return this.lock;
    }

    public String getExtension() {
        return this.extension;
    }

    public Boolean getIsPackage() {
        return this.isPackage;
    }

    public FileFullExpiringEmbedLinkField getExpiringEmbedLink() {
        return this.expiringEmbedLink;
    }

    public FileFullWatermarkInfoField getWatermarkInfo() {
        return this.watermarkInfo;
    }

    public Boolean getIsAccessibleViaSharedLink() {
        return this.isAccessibleViaSharedLink;
    }

    public List<EnumWrapper<FileFullAllowedInviteeRolesField>> getAllowedInviteeRoles() {
        return this.allowedInviteeRoles;
    }

    public Boolean getIsExternallyOwned() {
        return this.isExternallyOwned;
    }

    public Boolean getHasCollaborations() {
        return this.hasCollaborations;
    }

    public FileFullMetadataField getMetadata() {
        return this.metadata;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public FileFullRepresentationsField getRepresentations() {
        return this.representations;
    }

    public FileFullClassificationField getClassification() {
        return this.classification;
    }

    public String getUploaderDisplayName() {
        return this.uploaderDisplayName;
    }

    public Date getDispositionAt() {
        return this.dispositionAt;
    }

    public List<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> getSharedLinkPermissionOptions() {
        return this.sharedLinkPermissionOptions;
    }

    public Boolean getIsAssociatedWithAppItem() {
        return this.isAssociatedWithAppItem;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileFull casted = (FileFull)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.etag, casted.etag) && Objects.equals(this.type, casted.type) && Objects.equals(this.sequenceId, casted.sequenceId) && Objects.equals(this.name, casted.name) && Objects.equals(this.sha1, casted.sha1) && Objects.equals(this.fileVersion, casted.fileVersion) && Objects.equals(this.description, casted.description) && Objects.equals(this.size, casted.size) && Objects.equals(this.pathCollection, casted.pathCollection) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.modifiedAt, casted.modifiedAt) && Objects.equals(this.trashedAt, casted.trashedAt) && Objects.equals(this.purgedAt, casted.purgedAt) && Objects.equals(this.contentCreatedAt, casted.contentCreatedAt) && Objects.equals(this.contentModifiedAt, casted.contentModifiedAt) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.modifiedBy, casted.modifiedBy) && Objects.equals(this.ownedBy, casted.ownedBy) && Objects.equals(this.sharedLink, casted.sharedLink) && Objects.equals(this.parent, casted.parent) && Objects.equals(this.itemStatus, casted.itemStatus) && Objects.equals(this.versionNumber, casted.versionNumber) && Objects.equals(this.commentCount, casted.commentCount) && Objects.equals(this.permissions, casted.permissions) && Objects.equals(this.tags, casted.tags) && Objects.equals(this.lock, casted.lock) && Objects.equals(this.extension, casted.extension) && Objects.equals(this.isPackage, casted.isPackage) && Objects.equals(this.expiringEmbedLink, casted.expiringEmbedLink) && Objects.equals(this.watermarkInfo, casted.watermarkInfo) && Objects.equals(this.isAccessibleViaSharedLink, casted.isAccessibleViaSharedLink) && Objects.equals(this.allowedInviteeRoles, casted.allowedInviteeRoles) && Objects.equals(this.isExternallyOwned, casted.isExternallyOwned) && Objects.equals(this.hasCollaborations, casted.hasCollaborations) && Objects.equals(this.metadata, casted.metadata) && Objects.equals(this.expiresAt, casted.expiresAt) && Objects.equals(this.representations, casted.representations) && Objects.equals(this.classification, casted.classification) && Objects.equals(this.uploaderDisplayName, casted.uploaderDisplayName) && Objects.equals(this.dispositionAt, casted.dispositionAt) && Objects.equals(this.sharedLinkPermissionOptions, casted.sharedLinkPermissionOptions) && Objects.equals(this.isAssociatedWithAppItem, casted.isAssociatedWithAppItem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.etag, this.type, this.sequenceId, this.name, this.sha1, this.fileVersion, this.description, this.size, this.pathCollection, this.createdAt, this.modifiedAt, this.trashedAt, this.purgedAt, this.contentCreatedAt, this.contentModifiedAt, this.createdBy, this.modifiedBy, this.ownedBy, this.sharedLink, this.parent, this.itemStatus, this.versionNumber, this.commentCount, this.permissions, this.tags, this.lock, this.extension, this.isPackage, this.expiringEmbedLink, this.watermarkInfo, this.isAccessibleViaSharedLink, this.allowedInviteeRoles, this.isExternallyOwned, this.hasCollaborations, this.metadata, this.expiresAt, this.representations, this.classification, this.uploaderDisplayName, this.dispositionAt, this.sharedLinkPermissionOptions, this.isAssociatedWithAppItem);
    }

    @Override
    public String toString() {
        return "FileFull{id='" + this.id + '\'' + ", etag='" + this.etag + '\'' + ", type='" + this.type + '\'' + ", sequenceId='" + this.sequenceId + '\'' + ", name='" + this.name + '\'' + ", sha1='" + this.sha1 + '\'' + ", fileVersion='" + this.fileVersion + '\'' + ", description='" + this.description + '\'' + ", size='" + this.size + '\'' + ", pathCollection='" + this.pathCollection + '\'' + ", createdAt='" + this.createdAt + '\'' + ", modifiedAt='" + this.modifiedAt + '\'' + ", trashedAt='" + this.trashedAt + '\'' + ", purgedAt='" + this.purgedAt + '\'' + ", contentCreatedAt='" + this.contentCreatedAt + '\'' + ", contentModifiedAt='" + this.contentModifiedAt + '\'' + ", createdBy='" + this.createdBy + '\'' + ", modifiedBy='" + this.modifiedBy + '\'' + ", ownedBy='" + this.ownedBy + '\'' + ", sharedLink='" + this.sharedLink + '\'' + ", parent='" + this.parent + '\'' + ", itemStatus='" + this.itemStatus + '\'' + ", versionNumber='" + this.versionNumber + '\'' + ", commentCount='" + this.commentCount + '\'' + ", permissions='" + this.permissions + '\'' + ", tags='" + this.tags + '\'' + ", lock='" + this.lock + '\'' + ", extension='" + this.extension + '\'' + ", isPackage='" + this.isPackage + '\'' + ", expiringEmbedLink='" + this.expiringEmbedLink + '\'' + ", watermarkInfo='" + this.watermarkInfo + '\'' + ", isAccessibleViaSharedLink='" + this.isAccessibleViaSharedLink + '\'' + ", allowedInviteeRoles='" + this.allowedInviteeRoles + '\'' + ", isExternallyOwned='" + this.isExternallyOwned + '\'' + ", hasCollaborations='" + this.hasCollaborations + '\'' + ", metadata='" + this.metadata + '\'' + ", expiresAt='" + this.expiresAt + '\'' + ", representations='" + this.representations + '\'' + ", classification='" + this.classification + '\'' + ", uploaderDisplayName='" + this.uploaderDisplayName + '\'' + ", dispositionAt='" + this.dispositionAt + '\'' + ", sharedLinkPermissionOptions='" + this.sharedLinkPermissionOptions + '\'' + ", isAssociatedWithAppItem='" + this.isAssociatedWithAppItem + '\'' + "}";
    }

    public static class SharedLinkPermissionOptionsSerializer
    extends JsonSerializer<List<EnumWrapper<FileFullSharedLinkPermissionOptionsField>>> {
        public final JsonSerializer<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> elementSerializer = new FileFullSharedLinkPermissionOptionsField.FileFullSharedLinkPermissionOptionsFieldSerializer();

        public void serialize(List<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (EnumWrapper<FileFullSharedLinkPermissionOptionsField> item : value) {
                this.elementSerializer.serialize(item, gen, serializers);
            }
            gen.writeEndArray();
        }
    }

    public static class SharedLinkPermissionOptionsDeserializer
    extends JsonDeserializer<List<EnumWrapper<FileFullSharedLinkPermissionOptionsField>>> {
        public final JsonDeserializer<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> elementDeserializer = new FileFullSharedLinkPermissionOptionsField.FileFullSharedLinkPermissionOptionsFieldDeserializer();

        public List<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            ArrayList<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> elements = new ArrayList<EnumWrapper<FileFullSharedLinkPermissionOptionsField>>();
            for (JsonNode item : node) {
                JsonParser pa = item.traverse(p.getCodec());
                pa.nextToken();
                elements.add((EnumWrapper<FileFullSharedLinkPermissionOptionsField>)this.elementDeserializer.deserialize(pa, ctxt));
            }
            return elements;
        }
    }

    public static class AllowedInviteeRolesSerializer
    extends JsonSerializer<List<EnumWrapper<FileFullAllowedInviteeRolesField>>> {
        public final JsonSerializer<EnumWrapper<FileFullAllowedInviteeRolesField>> elementSerializer = new FileFullAllowedInviteeRolesField.FileFullAllowedInviteeRolesFieldSerializer();

        public void serialize(List<EnumWrapper<FileFullAllowedInviteeRolesField>> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (EnumWrapper<FileFullAllowedInviteeRolesField> item : value) {
                this.elementSerializer.serialize(item, gen, serializers);
            }
            gen.writeEndArray();
        }
    }

    public static class AllowedInviteeRolesDeserializer
    extends JsonDeserializer<List<EnumWrapper<FileFullAllowedInviteeRolesField>>> {
        public final JsonDeserializer<EnumWrapper<FileFullAllowedInviteeRolesField>> elementDeserializer = new FileFullAllowedInviteeRolesField.FileFullAllowedInviteeRolesFieldDeserializer();

        public List<EnumWrapper<FileFullAllowedInviteeRolesField>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            ArrayList<EnumWrapper<FileFullAllowedInviteeRolesField>> elements = new ArrayList<EnumWrapper<FileFullAllowedInviteeRolesField>>();
            for (JsonNode item : node) {
                JsonParser pa = item.traverse(p.getCodec());
                pa.nextToken();
                elements.add((EnumWrapper<FileFullAllowedInviteeRolesField>)this.elementDeserializer.deserialize(pa, ctxt));
            }
            return elements;
        }
    }

    public static class Builder
    extends File.Builder {
        protected String versionNumber;
        protected Long commentCount;
        protected FileFullPermissionsField permissions;
        protected List<String> tags;
        protected FileFullLockField lock;
        protected String extension;
        protected Boolean isPackage;
        protected FileFullExpiringEmbedLinkField expiringEmbedLink;
        protected FileFullWatermarkInfoField watermarkInfo;
        protected Boolean isAccessibleViaSharedLink;
        protected List<EnumWrapper<FileFullAllowedInviteeRolesField>> allowedInviteeRoles;
        protected Boolean isExternallyOwned;
        protected Boolean hasCollaborations;
        protected FileFullMetadataField metadata;
        protected Date expiresAt;
        protected FileFullRepresentationsField representations;
        protected FileFullClassificationField classification;
        protected String uploaderDisplayName;
        protected Date dispositionAt;
        protected List<EnumWrapper<FileFullSharedLinkPermissionOptionsField>> sharedLinkPermissionOptions;
        protected Boolean isAssociatedWithAppItem;

        public Builder(String id) {
            super(id);
        }

        public Builder versionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public Builder commentCount(Long commentCount) {
            this.commentCount = commentCount;
            return this;
        }

        public Builder permissions(FileFullPermissionsField permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder lock(FileFullLockField lock) {
            this.lock = lock;
            this.markNullableFieldAsSet("lock");
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder isPackage(Boolean isPackage) {
            this.isPackage = isPackage;
            return this;
        }

        public Builder expiringEmbedLink(FileFullExpiringEmbedLinkField expiringEmbedLink) {
            this.expiringEmbedLink = expiringEmbedLink;
            return this;
        }

        public Builder watermarkInfo(FileFullWatermarkInfoField watermarkInfo) {
            this.watermarkInfo = watermarkInfo;
            return this;
        }

        public Builder isAccessibleViaSharedLink(Boolean isAccessibleViaSharedLink) {
            this.isAccessibleViaSharedLink = isAccessibleViaSharedLink;
            return this;
        }

        public Builder allowedInviteeRoles(List<? extends Valuable> allowedInviteeRoles) {
            this.allowedInviteeRoles = EnumWrapper.wrapValuableEnumList(allowedInviteeRoles, FileFullAllowedInviteeRolesField.class);
            return this;
        }

        public Builder isExternallyOwned(Boolean isExternallyOwned) {
            this.isExternallyOwned = isExternallyOwned;
            return this;
        }

        public Builder hasCollaborations(Boolean hasCollaborations) {
            this.hasCollaborations = hasCollaborations;
            return this;
        }

        public Builder metadata(FileFullMetadataField metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder expiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
            this.markNullableFieldAsSet("expires_at");
            return this;
        }

        public Builder representations(FileFullRepresentationsField representations) {
            this.representations = representations;
            return this;
        }

        public Builder classification(FileFullClassificationField classification) {
            this.classification = classification;
            return this;
        }

        public Builder uploaderDisplayName(String uploaderDisplayName) {
            this.uploaderDisplayName = uploaderDisplayName;
            return this;
        }

        public Builder dispositionAt(Date dispositionAt) {
            this.dispositionAt = dispositionAt;
            this.markNullableFieldAsSet("disposition_at");
            return this;
        }

        public Builder sharedLinkPermissionOptions(List<? extends Valuable> sharedLinkPermissionOptions) {
            this.sharedLinkPermissionOptions = EnumWrapper.wrapValuableEnumList(sharedLinkPermissionOptions, FileFullSharedLinkPermissionOptionsField.class);
            this.markNullableFieldAsSet("shared_link_permission_options");
            return this;
        }

        public Builder isAssociatedWithAppItem(Boolean isAssociatedWithAppItem) {
            this.isAssociatedWithAppItem = isAssociatedWithAppItem;
            return this;
        }

        @Override
        public Builder etag(String etag) {
            this.etag = etag;
            this.markNullableFieldAsSet("etag");
            return this;
        }

        @Override
        public Builder type(FileBaseTypeField type) {
            this.type = new EnumWrapper<FileBaseTypeField>(type);
            return this;
        }

        @Override
        public Builder type(EnumWrapper<FileBaseTypeField> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder sequenceId(String sequenceId) {
            this.sequenceId = sequenceId;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder sha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        @Override
        public Builder fileVersion(FileVersionMini fileVersion) {
            this.fileVersion = fileVersion;
            return this;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        @Override
        public Builder pathCollection(FilePathCollectionField pathCollection) {
            this.pathCollection = pathCollection;
            return this;
        }

        @Override
        public Builder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public Builder modifiedAt(Date modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        @Override
        public Builder trashedAt(Date trashedAt) {
            this.trashedAt = trashedAt;
            this.markNullableFieldAsSet("trashed_at");
            return this;
        }

        @Override
        public Builder purgedAt(Date purgedAt) {
            this.purgedAt = purgedAt;
            this.markNullableFieldAsSet("purged_at");
            return this;
        }

        @Override
        public Builder contentCreatedAt(Date contentCreatedAt) {
            this.contentCreatedAt = contentCreatedAt;
            this.markNullableFieldAsSet("content_created_at");
            return this;
        }

        @Override
        public Builder contentModifiedAt(Date contentModifiedAt) {
            this.contentModifiedAt = contentModifiedAt;
            this.markNullableFieldAsSet("content_modified_at");
            return this;
        }

        @Override
        public Builder createdBy(UserMini createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public Builder modifiedBy(UserMini modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this;
        }

        @Override
        public Builder ownedBy(UserMini ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        @Override
        public Builder sharedLink(FileSharedLinkField sharedLink) {
            this.sharedLink = sharedLink;
            return this;
        }

        @Override
        public Builder parent(FolderMini parent) {
            this.parent = parent;
            this.markNullableFieldAsSet("parent");
            return this;
        }

        @Override
        public Builder itemStatus(FileItemStatusField itemStatus) {
            this.itemStatus = new EnumWrapper<FileItemStatusField>(itemStatus);
            return this;
        }

        @Override
        public Builder itemStatus(EnumWrapper<FileItemStatusField> itemStatus) {
            this.itemStatus = itemStatus;
            return this;
        }

        @Override
        public FileFull build() {
            return new FileFull(this);
        }
    }
}

