/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.collaboration;

import com.box.sdkgen.internal.Nullable;
import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.internal.utils.DateTimeUtils;
import com.box.sdkgen.schemas.appitem.AppItem;
import com.box.sdkgen.schemas.collaboration.CollaborationAcceptanceRequirementsStatusField;
import com.box.sdkgen.schemas.collaboration.CollaborationRoleField;
import com.box.sdkgen.schemas.collaboration.CollaborationStatusField;
import com.box.sdkgen.schemas.collaboration.CollaborationTypeField;
import com.box.sdkgen.schemas.file.File;
import com.box.sdkgen.schemas.fileorfolderorweblink.FileOrFolderOrWebLink;
import com.box.sdkgen.schemas.folder.Folder;
import com.box.sdkgen.schemas.groupmini.GroupMini;
import com.box.sdkgen.schemas.groupminiorusercollaborations.GroupMiniOrUserCollaborations;
import com.box.sdkgen.schemas.usercollaborations.UserCollaborations;
import com.box.sdkgen.schemas.weblink.WebLink;
import com.box.sdkgen.serialization.json.EnumWrapper;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class Collaboration
extends SerializableObject {
    protected final String id;
    @JsonDeserialize(using=CollaborationTypeField.CollaborationTypeFieldDeserializer.class)
    @JsonSerialize(using=CollaborationTypeField.CollaborationTypeFieldSerializer.class)
    protected EnumWrapper<CollaborationTypeField> type;
    @Nullable
    protected FileOrFolderOrWebLink item;
    @JsonProperty(value="app_item")
    @Nullable
    protected AppItem appItem;
    @JsonProperty(value="accessible_by")
    protected GroupMiniOrUserCollaborations accessibleBy;
    @JsonProperty(value="invite_email")
    @Nullable
    protected String inviteEmail;
    @JsonDeserialize(using=CollaborationRoleField.CollaborationRoleFieldDeserializer.class)
    @JsonSerialize(using=CollaborationRoleField.CollaborationRoleFieldSerializer.class)
    protected EnumWrapper<CollaborationRoleField> role;
    @JsonProperty(value="expires_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    @Nullable
    protected Date expiresAt;
    @JsonProperty(value="is_access_only")
    protected Boolean isAccessOnly;
    @JsonDeserialize(using=CollaborationStatusField.CollaborationStatusFieldDeserializer.class)
    @JsonSerialize(using=CollaborationStatusField.CollaborationStatusFieldSerializer.class)
    protected EnumWrapper<CollaborationStatusField> status;
    @JsonProperty(value="acknowledged_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected Date acknowledgedAt;
    @JsonProperty(value="created_by")
    protected UserCollaborations createdBy;
    @JsonProperty(value="created_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected Date createdAt;
    @JsonProperty(value="modified_at")
    @JsonSerialize(using=DateTimeUtils.DateTimeSerializer.class)
    @JsonDeserialize(using=DateTimeUtils.DateTimeDeserializer.class)
    protected Date modifiedAt;
    @JsonProperty(value="acceptance_requirements_status")
    protected CollaborationAcceptanceRequirementsStatusField acceptanceRequirementsStatus;

    public Collaboration(@JsonProperty(value="id") String id) {
        this.id = id;
        this.type = new EnumWrapper<CollaborationTypeField>(CollaborationTypeField.COLLABORATION);
    }

    protected Collaboration(Builder builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.item = builder.item;
        this.appItem = builder.appItem;
        this.accessibleBy = builder.accessibleBy;
        this.inviteEmail = builder.inviteEmail;
        this.role = builder.role;
        this.expiresAt = builder.expiresAt;
        this.isAccessOnly = builder.isAccessOnly;
        this.status = builder.status;
        this.acknowledgedAt = builder.acknowledgedAt;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.acceptanceRequirementsStatus = builder.acceptanceRequirementsStatus;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getId() {
        return this.id;
    }

    public EnumWrapper<CollaborationTypeField> getType() {
        return this.type;
    }

    public FileOrFolderOrWebLink getItem() {
        return this.item;
    }

    public AppItem getAppItem() {
        return this.appItem;
    }

    public GroupMiniOrUserCollaborations getAccessibleBy() {
        return this.accessibleBy;
    }

    public String getInviteEmail() {
        return this.inviteEmail;
    }

    public EnumWrapper<CollaborationRoleField> getRole() {
        return this.role;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public Boolean getIsAccessOnly() {
        return this.isAccessOnly;
    }

    public EnumWrapper<CollaborationStatusField> getStatus() {
        return this.status;
    }

    public Date getAcknowledgedAt() {
        return this.acknowledgedAt;
    }

    public UserCollaborations getCreatedBy() {
        return this.createdBy;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public CollaborationAcceptanceRequirementsStatusField getAcceptanceRequirementsStatus() {
        return this.acceptanceRequirementsStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collaboration casted = (Collaboration)o;
        return Objects.equals(this.id, casted.id) && Objects.equals(this.type, casted.type) && Objects.equals(this.item, casted.item) && Objects.equals(this.appItem, casted.appItem) && Objects.equals(this.accessibleBy, casted.accessibleBy) && Objects.equals(this.inviteEmail, casted.inviteEmail) && Objects.equals(this.role, casted.role) && Objects.equals(this.expiresAt, casted.expiresAt) && Objects.equals(this.isAccessOnly, casted.isAccessOnly) && Objects.equals(this.status, casted.status) && Objects.equals(this.acknowledgedAt, casted.acknowledgedAt) && Objects.equals(this.createdBy, casted.createdBy) && Objects.equals(this.createdAt, casted.createdAt) && Objects.equals(this.modifiedAt, casted.modifiedAt) && Objects.equals(this.acceptanceRequirementsStatus, casted.acceptanceRequirementsStatus);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.item, this.appItem, this.accessibleBy, this.inviteEmail, this.role, this.expiresAt, this.isAccessOnly, this.status, this.acknowledgedAt, this.createdBy, this.createdAt, this.modifiedAt, this.acceptanceRequirementsStatus);
    }

    public String toString() {
        return "Collaboration{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", item='" + this.item + '\'' + ", appItem='" + this.appItem + '\'' + ", accessibleBy='" + this.accessibleBy + '\'' + ", inviteEmail='" + this.inviteEmail + '\'' + ", role='" + this.role + '\'' + ", expiresAt='" + this.expiresAt + '\'' + ", isAccessOnly='" + this.isAccessOnly + '\'' + ", status='" + this.status + '\'' + ", acknowledgedAt='" + this.acknowledgedAt + '\'' + ", createdBy='" + this.createdBy + '\'' + ", createdAt='" + this.createdAt + '\'' + ", modifiedAt='" + this.modifiedAt + '\'' + ", acceptanceRequirementsStatus='" + this.acceptanceRequirementsStatus + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected final String id;
        protected EnumWrapper<CollaborationTypeField> type;
        protected FileOrFolderOrWebLink item;
        protected AppItem appItem;
        protected GroupMiniOrUserCollaborations accessibleBy;
        protected String inviteEmail;
        protected EnumWrapper<CollaborationRoleField> role;
        protected Date expiresAt;
        protected Boolean isAccessOnly;
        protected EnumWrapper<CollaborationStatusField> status;
        protected Date acknowledgedAt;
        protected UserCollaborations createdBy;
        protected Date createdAt;
        protected Date modifiedAt;
        protected CollaborationAcceptanceRequirementsStatusField acceptanceRequirementsStatus;

        public Builder(String id) {
            this.id = id;
            this.type = new EnumWrapper<CollaborationTypeField>(CollaborationTypeField.COLLABORATION);
        }

        public Builder type(CollaborationTypeField type) {
            this.type = new EnumWrapper<CollaborationTypeField>(type);
            return this;
        }

        public Builder type(EnumWrapper<CollaborationTypeField> type) {
            this.type = type;
            return this;
        }

        public Builder item(File item) {
            this.item = new FileOrFolderOrWebLink(item);
            this.markNullableFieldAsSet("item");
            return this;
        }

        public Builder item(Folder item) {
            this.item = new FileOrFolderOrWebLink(item);
            this.markNullableFieldAsSet("item");
            return this;
        }

        public Builder item(WebLink item) {
            this.item = new FileOrFolderOrWebLink(item);
            this.markNullableFieldAsSet("item");
            return this;
        }

        public Builder item(FileOrFolderOrWebLink item) {
            this.item = item;
            this.markNullableFieldAsSet("item");
            return this;
        }

        public Builder appItem(AppItem appItem) {
            this.appItem = appItem;
            this.markNullableFieldAsSet("app_item");
            return this;
        }

        public Builder accessibleBy(GroupMini accessibleBy) {
            this.accessibleBy = new GroupMiniOrUserCollaborations(accessibleBy);
            return this;
        }

        public Builder accessibleBy(UserCollaborations accessibleBy) {
            this.accessibleBy = new GroupMiniOrUserCollaborations(accessibleBy);
            return this;
        }

        public Builder accessibleBy(GroupMiniOrUserCollaborations accessibleBy) {
            this.accessibleBy = accessibleBy;
            return this;
        }

        public Builder inviteEmail(String inviteEmail) {
            this.inviteEmail = inviteEmail;
            this.markNullableFieldAsSet("invite_email");
            return this;
        }

        public Builder role(CollaborationRoleField role) {
            this.role = new EnumWrapper<CollaborationRoleField>(role);
            return this;
        }

        public Builder role(EnumWrapper<CollaborationRoleField> role) {
            this.role = role;
            return this;
        }

        public Builder expiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
            this.markNullableFieldAsSet("expires_at");
            return this;
        }

        public Builder isAccessOnly(Boolean isAccessOnly) {
            this.isAccessOnly = isAccessOnly;
            return this;
        }

        public Builder status(CollaborationStatusField status) {
            this.status = new EnumWrapper<CollaborationStatusField>(status);
            return this;
        }

        public Builder status(EnumWrapper<CollaborationStatusField> status) {
            this.status = status;
            return this;
        }

        public Builder acknowledgedAt(Date acknowledgedAt) {
            this.acknowledgedAt = acknowledgedAt;
            return this;
        }

        public Builder createdBy(UserCollaborations createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder modifiedAt(Date modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder acceptanceRequirementsStatus(CollaborationAcceptanceRequirementsStatusField acceptanceRequirementsStatus) {
            this.acceptanceRequirementsStatus = acceptanceRequirementsStatus;
            return this;
        }

        public Collaboration build() {
            return new Collaboration(this);
        }
    }
}

