/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.usercollaborations;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.usercollaborations.CreateCollaborationHeaders;
import com.box.sdkgen.managers.usercollaborations.CreateCollaborationQueryParams;
import com.box.sdkgen.managers.usercollaborations.CreateCollaborationRequestBody;
import com.box.sdkgen.managers.usercollaborations.DeleteCollaborationByIdHeaders;
import com.box.sdkgen.managers.usercollaborations.GetCollaborationByIdHeaders;
import com.box.sdkgen.managers.usercollaborations.GetCollaborationByIdQueryParams;
import com.box.sdkgen.managers.usercollaborations.UpdateCollaborationByIdHeaders;
import com.box.sdkgen.managers.usercollaborations.UpdateCollaborationByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.collaboration.Collaboration;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class UserCollaborationsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public UserCollaborationsManager() {
        this.networkSession = new NetworkSession();
    }

    protected UserCollaborationsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Collaboration getCollaborationById(String collaborationId) {
        return this.getCollaborationById(collaborationId, new GetCollaborationByIdQueryParams(), new GetCollaborationByIdHeaders());
    }

    public Collaboration getCollaborationById(String collaborationId, GetCollaborationByIdQueryParams queryParams) {
        return this.getCollaborationById(collaborationId, queryParams, new GetCollaborationByIdHeaders());
    }

    public Collaboration getCollaborationById(String collaborationId, GetCollaborationByIdHeaders headers) {
        return this.getCollaborationById(collaborationId, new GetCollaborationByIdQueryParams(), headers);
    }

    public Collaboration getCollaborationById(String collaborationId, GetCollaborationByIdQueryParams queryParams, GetCollaborationByIdHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaborations/", UtilsManager.convertToString(collaborationId)), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Collaboration.class);
    }

    public Collaboration updateCollaborationById(String collaborationId, UpdateCollaborationByIdRequestBody requestBody) {
        return this.updateCollaborationById(collaborationId, requestBody, new UpdateCollaborationByIdHeaders());
    }

    public Collaboration updateCollaborationById(String collaborationId, UpdateCollaborationByIdRequestBody requestBody, UpdateCollaborationByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaborations/", UtilsManager.convertToString(collaborationId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        if (UtilsManager.convertToString(response.getStatus()).equals("204")) {
            return null;
        }
        return JsonManager.deserialize(response.getData(), Collaboration.class);
    }

    public void deleteCollaborationById(String collaborationId) {
        this.deleteCollaborationById(collaborationId, new DeleteCollaborationByIdHeaders());
    }

    public void deleteCollaborationById(String collaborationId, DeleteCollaborationByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaborations/", UtilsManager.convertToString(collaborationId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Collaboration createCollaboration(CreateCollaborationRequestBody requestBody) {
        return this.createCollaboration(requestBody, new CreateCollaborationQueryParams(), new CreateCollaborationHeaders());
    }

    public Collaboration createCollaboration(CreateCollaborationRequestBody requestBody, CreateCollaborationQueryParams queryParams) {
        return this.createCollaboration(requestBody, queryParams, new CreateCollaborationHeaders());
    }

    public Collaboration createCollaboration(CreateCollaborationRequestBody requestBody, CreateCollaborationHeaders headers) {
        return this.createCollaboration(requestBody, new CreateCollaborationQueryParams(), headers);
    }

    public Collaboration createCollaboration(CreateCollaborationRequestBody requestBody, CreateCollaborationQueryParams queryParams, CreateCollaborationHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("notify", UtilsManager.convertToString(queryParams.getNotify()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collaborations"), "POST").params(queryParamsMap).headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Collaboration.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public UserCollaborationsManager build() {
            return new UserCollaborationsManager(this);
        }
    }
}

