/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.termsofservices;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.termsofservices.CreateTermsOfServiceHeaders;
import com.box.sdkgen.managers.termsofservices.CreateTermsOfServiceRequestBody;
import com.box.sdkgen.managers.termsofservices.GetTermsOfServiceByIdHeaders;
import com.box.sdkgen.managers.termsofservices.GetTermsOfServiceHeaders;
import com.box.sdkgen.managers.termsofservices.GetTermsOfServiceQueryParams;
import com.box.sdkgen.managers.termsofservices.UpdateTermsOfServiceByIdHeaders;
import com.box.sdkgen.managers.termsofservices.UpdateTermsOfServiceByIdRequestBody;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.termsofservice.TermsOfService;
import com.box.sdkgen.schemas.termsofservices.TermsOfServices;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class TermsOfServicesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public TermsOfServicesManager() {
        this.networkSession = new NetworkSession();
    }

    protected TermsOfServicesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public TermsOfServices getTermsOfService() {
        return this.getTermsOfService(new GetTermsOfServiceQueryParams(), new GetTermsOfServiceHeaders());
    }

    public TermsOfServices getTermsOfService(GetTermsOfServiceQueryParams queryParams) {
        return this.getTermsOfService(queryParams, new GetTermsOfServiceHeaders());
    }

    public TermsOfServices getTermsOfService(GetTermsOfServiceHeaders headers) {
        return this.getTermsOfService(new GetTermsOfServiceQueryParams(), headers);
    }

    public TermsOfServices getTermsOfService(GetTermsOfServiceQueryParams queryParams, GetTermsOfServiceHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("tos_type", UtilsManager.convertToString(queryParams.getTosType()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/terms_of_services"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TermsOfServices.class);
    }

    public TermsOfService createTermsOfService(CreateTermsOfServiceRequestBody requestBody) {
        return this.createTermsOfService(requestBody, new CreateTermsOfServiceHeaders());
    }

    public TermsOfService createTermsOfService(CreateTermsOfServiceRequestBody requestBody, CreateTermsOfServiceHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/terms_of_services"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TermsOfService.class);
    }

    public TermsOfService getTermsOfServiceById(String termsOfServiceId) {
        return this.getTermsOfServiceById(termsOfServiceId, new GetTermsOfServiceByIdHeaders());
    }

    public TermsOfService getTermsOfServiceById(String termsOfServiceId, GetTermsOfServiceByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/terms_of_services/", UtilsManager.convertToString(termsOfServiceId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TermsOfService.class);
    }

    public TermsOfService updateTermsOfServiceById(String termsOfServiceId, UpdateTermsOfServiceByIdRequestBody requestBody) {
        return this.updateTermsOfServiceById(termsOfServiceId, requestBody, new UpdateTermsOfServiceByIdHeaders());
    }

    public TermsOfService updateTermsOfServiceById(String termsOfServiceId, UpdateTermsOfServiceByIdRequestBody requestBody, UpdateTermsOfServiceByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/terms_of_services/", UtilsManager.convertToString(termsOfServiceId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), TermsOfService.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public TermsOfServicesManager build() {
            return new TermsOfServicesManager(this);
        }
    }
}

