/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.signtemplates;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.signtemplates.GetSignTemplateByIdHeaders;
import com.box.sdkgen.managers.signtemplates.GetSignTemplatesHeaders;
import com.box.sdkgen.managers.signtemplates.GetSignTemplatesQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.signtemplate.SignTemplate;
import com.box.sdkgen.schemas.signtemplates.SignTemplates;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class SignTemplatesManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public SignTemplatesManager() {
        this.networkSession = new NetworkSession();
    }

    protected SignTemplatesManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public SignTemplates getSignTemplates() {
        return this.getSignTemplates(new GetSignTemplatesQueryParams(), new GetSignTemplatesHeaders());
    }

    public SignTemplates getSignTemplates(GetSignTemplatesQueryParams queryParams) {
        return this.getSignTemplates(queryParams, new GetSignTemplatesHeaders());
    }

    public SignTemplates getSignTemplates(GetSignTemplatesHeaders headers) {
        return this.getSignTemplates(new GetSignTemplatesQueryParams(), headers);
    }

    public SignTemplates getSignTemplates(GetSignTemplatesQueryParams queryParams, GetSignTemplatesHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/sign_templates"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SignTemplates.class);
    }

    public SignTemplate getSignTemplateById(String templateId) {
        return this.getSignTemplateById(templateId, new GetSignTemplateByIdHeaders());
    }

    public SignTemplate getSignTemplateById(String templateId, GetSignTemplateByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/sign_templates/", UtilsManager.convertToString(templateId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), SignTemplate.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public SignTemplatesManager build() {
            return new SignTemplatesManager(this);
        }
    }
}

