/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.box.eventstream;

import com.box.sdkgen.box.errors.BoxSDKError;
import com.box.sdkgen.box.eventstream.EventStreamAction;
import com.box.sdkgen.box.eventstream.RealtimeServerEvent;
import com.box.sdkgen.managers.events.EventsManager;
import com.box.sdkgen.managers.events.GetEventStreamHeaders;
import com.box.sdkgen.managers.events.GetEventStreamQueryParams;
import com.box.sdkgen.managers.events.GetEventsHeaders;
import com.box.sdkgen.managers.events.GetEventsQueryParams;
import com.box.sdkgen.managers.events.GetEventsQueryParamsEventTypeField;
import com.box.sdkgen.managers.events.GetEventsQueryParamsStreamTypeField;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.schemas.event.Event;
import com.box.sdkgen.schemas.events.Events;
import com.box.sdkgen.schemas.realtimeserver.RealtimeServer;
import com.box.sdkgen.schemas.realtimeservers.RealtimeServers;
import com.box.sdkgen.serialization.json.Valuable;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

class EventStreamIterator
implements Iterator<Event> {
    private static final int DEDUPLICATION_SIZE = 1000;
    private final EventsManager eventsManager;
    private final GetEventStreamQueryParams queryParams;
    private final GetEventStreamHeaders headersInput;
    private String streamPosition;
    private RealtimeServer longPollInfo;
    private volatile boolean stopped;
    private final CountDownLatch stopLatch;
    private final Map<String, Boolean> dedupHash;
    private final List<Event> eventQueue;
    private boolean started;
    private int longPollingRetries;
    private static final int DEFAULT_MAX_RETRIES = 10;

    EventStreamIterator(EventsManager eventsManager, GetEventStreamQueryParams queryParams, GetEventStreamHeaders headersInput) {
        this.eventsManager = eventsManager;
        this.queryParams = queryParams;
        this.headersInput = headersInput;
        this.streamPosition = queryParams.getStreamPosition() != null ? queryParams.getStreamPosition() : "now";
        this.longPollInfo = null;
        this.started = false;
        this.stopped = false;
        this.stopLatch = new CountDownLatch(1);
        this.dedupHash = new HashMap<String, Boolean>();
        this.eventQueue = new ArrayList<Event>();
        this.longPollingRetries = 0;
    }

    @Override
    public boolean hasNext() {
        return !this.eventQueue.isEmpty() || !this.stopped && this.stopLatch.getCount() > 0L;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            this.stop();
            throw new NoSuchElementException("No more events available or stream stopped");
        }
        if (!this.eventQueue.isEmpty()) {
            return this.eventQueue.remove(0);
        }
        if (!this.started) {
            this.started = true;
            this.fetchEvents();
            if (!this.eventQueue.isEmpty()) {
                return this.eventQueue.remove(0);
            }
        }
        this.getLongPollInfo();
        while (!this.stopped && this.stopLatch.getCount() > 0L) {
            try {
                EventStreamAction action = this.doLongPoll();
                switch (action) {
                    case FETCH_EVENTS: {
                        this.fetchEvents();
                        if (this.eventQueue.isEmpty()) break;
                        return this.eventQueue.remove(0);
                    }
                    case RETRY: {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                    case RECONNECT: {
                        this.getLongPollInfo();
                        break;
                    }
                    case STOP: {
                        this.stop();
                    }
                }
            }
            catch (Exception e) {
                boolean isBoxError = e instanceof BoxSDKError;
                if (isBoxError) continue;
                throw e;
            }
        }
        throw new NoSuchElementException("Stream stopped");
    }

    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            this.stopLatch.countDown();
        }
    }

    private void getLongPollInfo() throws BoxSDKError {
        block6: {
            if (this.stopped || this.stopLatch.getCount() == 0L) {
                return;
            }
            try {
                RealtimeServers info = this.eventsManager.getEventsWithLongPolling();
                RealtimeServer server = null;
                if (info.getEntries() != null) {
                    for (RealtimeServer entry : info.getEntries()) {
                        if (!entry.getType().equals("realtime_server")) continue;
                        server = entry;
                        break;
                    }
                }
                if (server == null) {
                    throw new BoxSDKError("No realtime server found in the response.");
                }
                this.longPollInfo = server;
                this.longPollingRetries = 0;
            }
            catch (Exception e) {
                if (this.stopped || this.stopLatch.getCount() <= 0L) break block6;
                throw new BoxSDKError("Failed to fetch long polling info: " + (e.getMessage() != null ? e.getMessage() : ""), e);
            }
        }
    }

    private EventStreamAction doLongPoll() throws BoxSDKError {
        if (this.stopped || this.stopLatch.getCount() == 0L) {
            return EventStreamAction.STOP;
        }
        try {
            int maxRetries;
            int n = maxRetries = this.longPollInfo != null && this.longPollInfo.getMaxRetries() != null ? Integer.parseInt(this.longPollInfo.getMaxRetries()) : 10;
            if (this.longPollInfo == null || this.longPollingRetries > maxRetries) {
                this.getLongPollInfo();
            }
            ++this.longPollingRetries;
            String longPollUrl = this.longPollInfo.getUrl();
            String separator = longPollUrl.contains("?") ? "&" : "?";
            String longPollWithStreamPosition = longPollUrl + separator + "stream_position=" + this.streamPosition;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            FetchResponse response = this.eventsManager.getNetworkSession().getNetworkClient().fetch(new FetchOptions.Builder(longPollWithStreamPosition, "GET").responseFormat(ResponseFormat.JSON).auth(this.eventsManager.getAuth()).networkSession(this.eventsManager.getNetworkSession()).headers(headers).build());
            if (this.stopped || this.stopLatch.getCount() == 0L) {
                return EventStreamAction.STOP;
            }
            if (response.getStatus() == 200 && response.getData() != null) {
                String messageText;
                JsonNode message = response.getData();
                String string = messageText = message.has("message") ? message.get("message").asText() : null;
                if (RealtimeServerEvent.NEW_CHANGE.getValue().equals(messageText)) {
                    return EventStreamAction.FETCH_EVENTS;
                }
                if (RealtimeServerEvent.RECONNECT.getValue().equals(messageText)) {
                    return EventStreamAction.RECONNECT;
                }
            }
            return EventStreamAction.RETRY;
        }
        catch (Exception e) {
            if (!this.stopped && this.stopLatch.getCount() > 0L) {
                return EventStreamAction.RETRY;
            }
            return EventStreamAction.STOP;
        }
    }

    private void fetchEvents() throws BoxSDKError {
        block14: {
            if (this.stopped || this.stopLatch.getCount() == 0L) {
                return;
            }
            try {
                String eventId;
                GetEventsHeaders fetchHeaders;
                GetEventsQueryParams fetchParams;
                Events events;
                List eventTypes;
                GetEventsQueryParams.Builder fetchParamsBuilder = new GetEventsQueryParams.Builder().streamPosition(this.streamPosition);
                if (this.queryParams.getLimit() != null) {
                    fetchParamsBuilder.limit(this.queryParams.getLimit());
                }
                if (this.queryParams.getCreatedAfter() != null) {
                    fetchParamsBuilder.createdAfter(this.queryParams.getCreatedAfter());
                }
                if (this.queryParams.getCreatedBefore() != null) {
                    fetchParamsBuilder.createdBefore(this.queryParams.getCreatedBefore());
                }
                if (this.queryParams.getStreamType() != null) {
                    String streamTypeValue = this.queryParams.getStreamType().getValue();
                    GetEventsQueryParamsStreamTypeField streamType = this.convertStreamType(streamTypeValue);
                    fetchParamsBuilder.streamType(streamType);
                }
                List list = eventTypes = this.queryParams.getEventType() != null ? this.queryParams.getEventType().stream().map(enumWrapper -> this.convertEventType(enumWrapper.getValue())).collect(Collectors.toList()) : null;
                if (eventTypes != null) {
                    fetchParamsBuilder.eventType(eventTypes);
                }
                if ((events = this.eventsManager.getEvents(fetchParams = fetchParamsBuilder.build(), fetchHeaders = new GetEventsHeaders.Builder().extraHeaders(this.headersInput.getExtraHeaders() != null ? this.headersInput.getExtraHeaders() : new HashMap()).build())).getEntries() != null && !events.getEntries().isEmpty()) {
                    for (Event event : events.getEntries()) {
                        eventId = event.getEventId();
                        if (eventId == null || this.dedupHash.containsKey(eventId)) continue;
                        this.dedupHash.put(eventId, true);
                        if (this.stopped || this.stopLatch.getCount() == 0L) {
                            return;
                        }
                        this.eventQueue.add(event);
                    }
                }
                String string = events.getNextStreamPosition() != null ? (events.getNextStreamPosition().isString() ? events.getNextStreamPosition().getString() : String.valueOf(events.getNextStreamPosition().getLongNumber())) : (this.streamPosition = "now");
                if (this.dedupHash.size() >= 1000) {
                    this.dedupHash.clear();
                    for (Event event : events.getEntries()) {
                        eventId = event.getEventId();
                        if (eventId == null) continue;
                        this.dedupHash.put(eventId, true);
                    }
                }
            }
            catch (Exception e) {
                if (this.stopped || this.stopLatch.getCount() <= 0L) break block14;
                if (e instanceof BoxSDKError) {
                    throw (BoxSDKError)e;
                }
                throw new BoxSDKError("Failed to fetch events: " + (e.getMessage() != null ? e.getMessage() : ""), e);
            }
        }
    }

    private GetEventsQueryParamsStreamTypeField convertStreamType(String streamTypeValue) {
        if (streamTypeValue == null) {
            return null;
        }
        try {
            return GetEventsQueryParamsStreamTypeField.valueOf(streamTypeValue.toUpperCase().replace(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            throw new BoxSDKError("Invalid stream type: " + streamTypeValue);
        }
    }

    private Valuable convertEventType(String eventTypeValue) {
        if (eventTypeValue == null) {
            return null;
        }
        try {
            return GetEventsQueryParamsEventTypeField.valueOf(eventTypeValue.toUpperCase().replace(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            throw new BoxSDKError("Invalid event type: " + eventTypeValue);
        }
    }
}

