/*
 * Decompiled with CFR 0.152.
 */
package com.nanorep.accessibility.components;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.TextView;
import com.nanorep.accessibility.R;
import com.nanorep.accessibility.components.SpeecherView;
import com.nanorep.accessibility.voice.SpeechRecognitionProvider;
import com.nanorep.accessibility.voice.SpeechedTextListener;
import com.nanorep.accessibility.voice.VoiceRecognition;
import com.nanorep.accessibility.voice.engines.SpeechToText;
import com.nanorep.sdkcore.utils.NRError;
import com.nanorep.sdkcore.utils.UtilityMethodsKt;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0014J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J0\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010H\u0014J\b\u0010'\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0018H\u0016J\b\u0010,\u001a\u00020\u0018H\u0016J\u0012\u0010-\u001a\u00020\u00182\b\u0010.\u001a\u0004\u0018\u00010\u0002H\u0016J\u0006\u0010/\u001a\u00020\u0018J\u0012\u00100\u001a\u00020\u00182\b\u0010#\u001a\u0004\u0018\u00010\u000eH\u0016J\u0006\u00101\u001a\u00020\u0018R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0002X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lcom/nanorep/accessibility/components/SpeecherView;", "Landroid/view/ViewGroup;", "Lcom/nanorep/accessibility/voice/SpeechedTextListener;", "context", "Landroid/content/Context;", "attributes", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "innerListener", "getInnerListener", "()Lcom/nanorep/accessibility/voice/SpeechedTextListener;", "setInnerListener", "(Lcom/nanorep/accessibility/voice/SpeechedTextListener;)V", "myClickListener", "Landroid/view/View$OnClickListener;", "textId", "", "textView", "Landroid/widget/TextView;", "voiceRecognition", "Lcom/nanorep/accessibility/voice/VoiceRecognition;", "getVoiceRecognition", "()Lcom/nanorep/accessibility/voice/VoiceRecognition;", "bindOutputView", "", "cancelSpeech", "getOnClickListener", "onActive", "onAttachedToWindow", "onError", "error", "Lcom/nanorep/sdkcore/utils/NRError;", "onLayout", "changed", "", "l", "t", "r", "b", "onPrepared", "onResults", "text", "", "onStart", "onStop", "registerListener", "listener", "release", "setOnClickListener", "stop", "accessibility_release"})
public class SpeecherView
extends ViewGroup
implements SpeechedTextListener {
    @NotNull
    private final VoiceRecognition voiceRecognition;
    private int textId;
    private TextView textView;
    @Nullable
    private SpeechedTextListener innerListener;
    private View.OnClickListener myClickListener;
    private HashMap _$_findViewCache;

    @NotNull
    protected final VoiceRecognition getVoiceRecognition() {
        return this.voiceRecognition;
    }

    @Nullable
    protected final SpeechedTextListener getInnerListener() {
        return this.innerListener;
    }

    protected final void setInnerListener(@Nullable SpeechedTextListener speechedTextListener) {
        this.innerListener = speechedTextListener;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public final void bindOutputView(@NotNull TextView textView) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        this.textView = textView;
    }

    public void registerListener(@Nullable SpeechedTextListener listener) {
        this.innerListener = listener;
    }

    @Override
    public void onResults(@NotNull String text) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            SpeechedTextListener speechedTextListener = this.innerListener;
            if (speechedTextListener != null) {
                speechedTextListener.onResults(text);
            }
            TextView textView = this.textView;
            if (textView == null) break block1;
            textView.setText((CharSequence)text);
        }
    }

    @Override
    public void onActive() {
        block0: {
            SpeechedTextListener speechedTextListener = this.innerListener;
            if (speechedTextListener == null) break block0;
            speechedTextListener.onActive();
        }
    }

    @Override
    public void onPrepared() {
        block0: {
            SpeechedTextListener speechedTextListener = this.innerListener;
            if (speechedTextListener == null) break block0;
            speechedTextListener.onPrepared();
        }
    }

    @Override
    public void onStart() {
        block0: {
            SpeechedTextListener speechedTextListener = this.innerListener;
            if (speechedTextListener == null) break block0;
            speechedTextListener.onStart();
        }
    }

    @Override
    public void onStop() {
        block0: {
            SpeechedTextListener speechedTextListener = this.innerListener;
            if (speechedTextListener == null) break block0;
            speechedTextListener.onStop();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.textId != -1) {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            this.textView = (TextView)UtilityMethodsKt.searchForView((View)((View)((ViewGroup)viewParent)), (int)this.textId);
        }
    }

    @Override
    public void onError(@NotNull NRError error) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            SpeechedTextListener speechedTextListener = this.innerListener;
            if (speechedTextListener == null) break block0;
            speechedTextListener.onError(error);
        }
    }

    public final void release() {
        this.setEnabled(false);
        this.voiceRecognition.release();
        this.innerListener = null;
    }

    public final void cancelSpeech() {
        block0: {
            SpeechRecognitionProvider speechRecognitionProvider = this.voiceRecognition.getSpeechAdminister();
            if (speechRecognitionProvider == null) break block0;
            speechRecognitionProvider.cancel();
        }
    }

    public final void stop() {
        block0: {
            SpeechRecognitionProvider speechRecognitionProvider = this.voiceRecognition.getSpeechAdminister();
            if (speechRecognitionProvider == null) break block0;
            speechRecognitionProvider.stop();
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        super.setOnClickListener(l);
        this.myClickListener = l;
    }

    @Nullable
    public final View.OnClickListener getOnClickListener() {
        return this.myClickListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpeecherView(@NotNull Context context, @Nullable AttributeSet attributes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributes);
        this.voiceRecognition = VoiceRecognition.Companion.create(context, (Function1<? super VoiceRecognition.Builder, Unit>)((Function1)new Function1<VoiceRecognition.Builder, Unit>(this, context){
            final /* synthetic */ SpeecherView this$0;
            final /* synthetic */ Context $context;

            public final void invoke(@NotNull VoiceRecognition.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                $receiver.speechAdminister((Function1<? super VoiceRecognition.Builder, ? extends SpeechRecognitionProvider>)((Function1)new Function1<VoiceRecognition.Builder, SpeechToText>(this){
                    final /* synthetic */ voiceRecognition.1 this$0;

                    @NotNull
                    public final SpeechToText invoke(@NotNull VoiceRecognition.Builder $this$speechAdminister) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$speechAdminister, (String)"$receiver");
                        return new SpeechToText(this.this$0.$context);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                $receiver.speechListener((Function1<? super VoiceRecognition.Builder, ? extends SpeechedTextListener>)((Function1)new Function1<VoiceRecognition.Builder, SpeecherView>(this){
                    final /* synthetic */ voiceRecognition.1 this$0;

                    @NotNull
                    public final SpeecherView invoke(@NotNull VoiceRecognition.Builder $this$speechListener) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$speechListener, (String)"$receiver");
                        return this.this$0.this$0;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                $receiver.bindActionView((Function1<? super VoiceRecognition.Builder, ? extends View>)((Function1)new Function1<VoiceRecognition.Builder, SpeecherView>(this){
                    final /* synthetic */ voiceRecognition.1 this$0;

                    @NotNull
                    public final SpeecherView invoke(@NotNull VoiceRecognition.Builder $this$bindActionView) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$bindActionView, (String)"$receiver");
                        return this.this$0.this$0;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = speecherView;
                this.$context = context;
                super(1);
            }
        }));
        this.textId = -1;
        if (attributes != null) {
            TypedArray a = context.obtainStyledAttributes(attributes, R.styleable.SpeecherView, 0, 0);
            try {
                this.textId = a.getResourceId(R.styleable.SpeecherView_textView, -1);
                this.setId(-1);
            }
            catch (Exception e) {
                this.textView = null;
            }
            finally {
                TypedArray typedArray = a;
                if (typedArray != null) {
                    typedArray.recycle();
                }
            }
        }
        this.setClickable(true);
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
    }

    @Override
    public void onReady() {
        SpeechedTextListener.DefaultImpls.onReady(this);
    }

    @Override
    public void onIdle() {
        SpeechedTextListener.DefaultImpls.onIdle(this);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

