/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.VolumeBind;
import com.github.dockerjava.api.model.VolumesFrom;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;

public class DockerInspectContainer
extends DockerExistingContainer {
    public DockerInspectContainer() {
        this.defaultResponseHandling();
    }

    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet("Inspecting container with ID '" + (String)this.getContainerId().get() + "'.");
        InspectContainerResponse container = this.getDockerClient().inspectContainerCmd((String)this.getContainerId().get()).exec();
        if (this.getNextHandler() != null) {
            this.getNextHandler().execute((Object)container);
        }
    }

    private void defaultResponseHandling() {
        Action<InspectContainerResponse> action = new Action<InspectContainerResponse>(){

            public void execute(InspectContainerResponse container) {
                DockerInspectContainer.this.getLogger().quiet("Image ID    : " + container.getImageId());
                DockerInspectContainer.this.getLogger().quiet("Name        : " + container.getName());
                DockerInspectContainer.this.getLogger().quiet("Links       : " + Arrays.toString(container.getHostConfig().getLinks()));
                Object[] volumes = container.getVolumes() != null ? container.getVolumes() : new VolumeBind[]{};
                DockerInspectContainer.this.getLogger().quiet("Volumes     : " + Arrays.toString(volumes));
                Object[] volumesFrom = container.getHostConfig().getVolumesFrom() != null ? container.getHostConfig().getVolumesFrom() : new VolumesFrom[]{};
                DockerInspectContainer.this.getLogger().quiet("VolumesFrom : " + Arrays.toString(volumesFrom));
                Object[] exposedPorts = container.getConfig().getExposedPorts() != null ? container.getConfig().getExposedPorts() : new ExposedPort[]{};
                DockerInspectContainer.this.getLogger().quiet("ExposedPorts : " + Arrays.toString(exposedPorts));
                DockerInspectContainer.this.getLogger().quiet("LogConfig : " + container.getHostConfig().getLogConfig().getType().getType());
                DockerInspectContainer.this.getLogger().quiet("RestartPolicy : " + container.getHostConfig().getRestartPolicy());
                DockerInspectContainer.this.getLogger().quiet("PidMode : " + container.getHostConfig().getPidMode());
                List devices = (container.getHostConfig().getDevices() != null ? Arrays.stream(container.getHostConfig().getDevices()) : Stream.empty()).map(it -> it.getPathOnHost() + ":" + it.getPathInContainer() + ":" + it.getcGroupPermissions()).collect(Collectors.toList());
                DockerInspectContainer.this.getLogger().quiet("Devices : " + devices);
                DockerInspectContainer.this.getLogger().quiet("TmpFs : " + container.getHostConfig().getTmpFs());
            }
        };
        this.onNext((Action)action);
    }
}

