/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.tasks.container;

import com.bmuschko.gradle.docker.domain.ExecProbe;
import com.bmuschko.gradle.docker.internal.IOUtils;
import com.bmuschko.gradle.docker.tasks.container.DockerExistingContainer;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.logging.progress.ProgressLogger;

public class DockerExecContainer
extends DockerExistingContainer {
    @Input
    @Optional
    private final ListProperty<String[]> commands;
    @Input
    @Optional
    private final Property<Boolean> attachStdout;
    @Input
    @Optional
    private final Property<Boolean> attachStderr;
    @Input
    @Optional
    private final Property<String> user;
    @Input
    @Optional
    private final Property<String> workingDir;
    @Input
    @Optional
    private final ListProperty<Integer> successOnExitCodes;
    @Nested
    @Optional
    private ExecProbe execProbe;
    @org.gradle.api.tasks.Internal
    private final ListProperty<String> execIds;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public DockerExecContainer() {
        ListProperty listProperty;
        ListProperty listProperty2;
        Property property;
        Property property2;
        Property property3;
        Property property4;
        ListProperty listProperty3;
        this.commands = listProperty3 = ((ProjectInternal)this.getProject()).getObjects().listProperty(String[].class);
        this.attachStdout = property4 = ((ProjectInternal)this.getProject()).getObjects().property(Boolean.class);
        this.attachStderr = property3 = ((ProjectInternal)this.getProject()).getObjects().property(Boolean.class);
        this.user = property2 = ((ProjectInternal)this.getProject()).getObjects().property(String.class);
        this.workingDir = property = ((ProjectInternal)this.getProject()).getObjects().property(String.class);
        this.successOnExitCodes = listProperty2 = ((ProjectInternal)this.getProject()).getObjects().listProperty(Integer.class);
        this.execIds = listProperty = ((ProjectInternal)this.getProject()).getObjects().listProperty(String.class);
        this.commands.empty();
        this.attachStdout.set((Object)true);
        this.attachStderr.set((Object)true);
        this.successOnExitCodes.empty();
        this.execIds.empty();
    }

    @Override
    public void runRemoteCommand() {
        this.getLogger().quiet(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getContainerId().get()}, new String[]{"Executing on container with ID '", "'."})));
        this.doRunRemoteCommand(this.getDockerClient());
    }

    protected void doRunRemoteCommand(DockerClient dockerClient) {
        ResultCallback.Adapter<Frame> execCallback = this.createCallback(this.getNextHandler());
        List localCommands = (List)ScriptBytecodeAdapter.castToType((Object)this.commands.get(), List.class);
        int i = 0;
        while (i < ((List)this.commands.get()).size()) {
            String[] singleCommand = (String[])ScriptBytecodeAdapter.castToType(localCommands.get(i), String[].class);
            ExecCreateCmd execCmd = dockerClient.execCreateCmd(ShortTypeHandling.castToString((Object)this.getContainerId().get()));
            this.setContainerCommandConfig(execCmd, singleCommand);
            String localExecId = ((ExecCreateCmdResponse)execCmd.exec()).getId();
            dockerClient.execStartCmd(localExecId).withDetach(false).exec(execCallback).awaitCompletion();
            ProgressLogger progressLogger = IOUtils.getProgressLogger(this.getProject(), DockerExecContainer.class);
            progressLogger.started();
            ExecProbe execProbe = this.execProbe;
            ExecProbe localProbe = DefaultTypeTransformation.booleanUnbox((Object)execProbe) ? execProbe : new ExecProbe(60000, 2000);
            long localPollTime = localProbe.getPollTime();
            int pollTimes = 0;
            boolean isRunning = true;
            InspectExecResponse lastExecResponse = null;
            while (isRunning && localPollTime > (long)0) {
                InspectExecResponse inspectExecResponse;
                int cfr_ignored_0 = pollTimes + 1;
                lastExecResponse = inspectExecResponse = dockerClient.inspectExecCmd(localExecId).exec();
                Boolean bl = lastExecResponse.isRunning();
                isRunning = DefaultTypeTransformation.booleanUnbox((Object)bl);
                if (!isRunning) break;
                long totalMillis = (long)pollTimes * localProbe.getPollInterval();
                long totalMinutes = TimeUnit.MILLISECONDS.toMinutes(totalMillis);
                progressLogger.progress(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{totalMinutes}, new String[]{"Executing for ", "m..."})));
                try {
                    long cfr_ignored_1 = localPollTime - localProbe.getPollInterval();
                    DefaultGroovyStaticMethods.sleep(null, (long)localProbe.getPollInterval());
                }
                catch (Exception e) {
                    throw (Throwable)e;
                }
            }
            progressLogger.completed();
            if (isRunning) {
                throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{singleCommand, localProbe}, new String[]{"Exec '", "' did not finish in a timely fashion: ", ""})));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)this.successOnExitCodes.getOrNull())) {
                Integer n = lastExecResponse.getExitCode();
                int exitCode = DefaultTypeTransformation.booleanUnbox((Object)n) ? n : Integer.valueOf(0);
                if (!((List)this.successOnExitCodes.get()).contains(exitCode)) {
                    throw (Throwable)new GradleException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{exitCode, this.successOnExitCodes.get(), lastExecResponse}, new String[]{"", " is not a successful exit code. Valid values are ", ", response=", ""})));
                }
            }
            this.execIds.add((Object)localExecId);
            int n = i;
            int cfr_ignored_2 = n + 1;
        }
    }

    public void withCommand(List<String> commandsToExecute) {
        this.withCommand((String[])ScriptBytecodeAdapter.asType(commandsToExecute, String[].class));
    }

    public void withCommand(String ... commandsToExecute) {
        if (DefaultTypeTransformation.booleanUnbox((Object)commandsToExecute)) {
            this.commands.add((Object)commandsToExecute);
        }
    }

    private void setContainerCommandConfig(ExecCreateCmd containerCommand, String ... commandToExecute) {
        if (DefaultTypeTransformation.booleanUnbox((Object)commandToExecute)) {
            containerCommand.withCmd(commandToExecute);
        }
        Object object = this.attachStderr.getOrNull();
        if (object == null ? false : (Boolean)object) {
            containerCommand.withAttachStderr((Boolean)ScriptBytecodeAdapter.castToType((Object)this.attachStderr.get(), Boolean.class));
        }
        Object object2 = this.attachStdout.getOrNull();
        if (object2 == null ? false : (Boolean)object2) {
            containerCommand.withAttachStdout((Boolean)ScriptBytecodeAdapter.castToType((Object)this.attachStdout.get(), Boolean.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.user.getOrNull())) {
            containerCommand.withUser(ShortTypeHandling.castToString((Object)this.user.get()));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.workingDir.getOrNull())) {
            containerCommand.withWorkingDir(ShortTypeHandling.castToString((Object)this.workingDir.get()));
        }
    }

    public Object execProbe(long pollTime, long pollInterval) {
        ExecProbe execProbe;
        this.execProbe = execProbe = new ExecProbe(pollTime, pollInterval);
        return execProbe;
    }

    private ResultCallback.Adapter<Frame> createCallback(Action nextHandler) {
        Reference nextHandler2 = new Reference((Object)nextHandler);
        if (DefaultTypeTransformation.booleanUnbox((Object)((Action)nextHandler2.get()))) {
            return new GroovyObject(this, nextHandler2){
                public /* synthetic */ Reference nextHandler;
                public /* synthetic */ DockerExecContainer this$0;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private transient /* synthetic */ MetaClass metaClass;
                {
                    MetaClass metaClass;
                    Reference reference;
                    DockerExecContainer dockerExecContainer;
                    this.this$0 = dockerExecContainer = p0;
                    this.nextHandler = reference = p1;
                    this.metaClass = metaClass = this.$getStaticMetaClass();
                }

                @Override
                public void onNext(Frame frame) {
                    try {
                        ((Action)this.nextHandler.get()).execute((Object)frame);
                    }
                    catch (Exception e) {
                        this.this$0.getLogger().error("Failed to handle frame", e);
                        return;
                    }
                    super.onNext(frame);
                }

                public /* synthetic */ Object methodMissing(String name, Object args) {
                    return this.this$0.this$dist$invoke$5(name, args);
                }

                public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, DockerExecContainer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                }

                public /* synthetic */ void propertyMissing(String name, Object val) {
                    this.this$0.this$dist$set$5(name, val);
                }

                public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                    Object object = val;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, DockerExecContainer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                public /* synthetic */ Object propertyMissing(String name) {
                    return this.this$0.this$dist$get$5(name);
                }

                public static /* synthetic */ Object $static_propertyMissing(String name) {
                    return ScriptBytecodeAdapter.getProperty(1.class, DockerExecContainer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (this.getClass() != 1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)this);
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                    }
                    return classInfo.getMetaClass();
                }

                @Generated
                @Internal
                public /* synthetic */ MetaClass getMetaClass() {
                    MetaClass metaClass = this.metaClass;
                    if (metaClass != null) {
                        return metaClass;
                    }
                    this.metaClass = this.$getStaticMetaClass();
                    return this.metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                    this.metaClass = metaClass;
                }

                @Generated
                @Internal
                public /* synthetic */ Object invokeMethod(String string, Object object) {
                    return this.getMetaClass().invokeMethod((Object)this, string, object);
                }

                @Generated
                @Internal
                public /* synthetic */ Object getProperty(String string) {
                    return this.getMetaClass().getProperty((Object)this, string);
                }

                @Generated
                @Internal
                public /* synthetic */ void setProperty(String string, Object object) {
                    this.getMetaClass().setProperty((Object)this, string, object);
                }
            };
        }
        return new GroovyObject(this){
            public /* synthetic */ DockerExecContainer this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                DockerExecContainer dockerExecContainer;
                this.this$0 = dockerExecContainer = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void onNext(Frame frame) {
                if (frame != null) {
                    StreamType streamType = frame.getStreamType();
                    if (ScriptBytecodeAdapter.isCase((Object)((Object)streamType), (Object)((Object)StreamType.STDOUT)) || ScriptBytecodeAdapter.isCase((Object)((Object)streamType), (Object)((Object)StreamType.RAW))) {
                        System.out.write(frame.getPayload());
                        System.out.flush();
                    } else if (ScriptBytecodeAdapter.isCase((Object)((Object)streamType), (Object)((Object)StreamType.STDERR))) {
                        System.err.write(frame.getPayload());
                        System.err.flush();
                    } else {
                        this.this$0.getLogger().error(StringGroovyMethods.plus((CharSequence)"unknown stream type:", (Object)((Object)frame.getStreamType())));
                    }
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$5(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, DockerExecContainer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$5(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DockerExecContainer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$5(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, DockerExecContainer.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        };
    }

    public /* synthetic */ Object this$dist$invoke$5(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DockerExecContainer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$5(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DockerExecContainer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$5(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DockerExecContainer.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != DockerExecContainer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public final ListProperty<String[]> getCommands() {
        return this.commands;
    }

    @Generated
    public final Property<Boolean> getAttachStdout() {
        return this.attachStdout;
    }

    @Generated
    public final Property<Boolean> getAttachStderr() {
        return this.attachStderr;
    }

    @Generated
    public final Property<String> getUser() {
        return this.user;
    }

    @Generated
    public final Property<String> getWorkingDir() {
        return this.workingDir;
    }

    @Generated
    public final ListProperty<Integer> getSuccessOnExitCodes() {
        return this.successOnExitCodes;
    }

    @Generated
    public ExecProbe getExecProbe() {
        return this.execProbe;
    }

    @Generated
    public void setExecProbe(ExecProbe execProbe) {
        this.execProbe = execProbe;
    }

    @Generated
    public final ListProperty<String> getExecIds() {
        return this.execIds;
    }
}

