/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.transport;

import com.github.dockerjava.transport.AbstractSocket;
import com.github.dockerjava.transport.BsdDomainSocket;
import com.github.dockerjava.transport.FileDescriptor;
import com.github.dockerjava.transport.LinuxDomainSocket;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public abstract class DomainSocket
extends AbstractSocket {
    private static final int SHUT_RD = 0;
    private static final int SHUT_WR = 1;
    protected static final int PF_LOCAL = 1;
    protected static final byte AF_LOCAL = 1;
    protected static final int SOCK_STREAM = 1;
    private final FileDescriptor fileDescriptor;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    DomainSocket(String path) throws IOException {
        try {
            this.fileDescriptor = this.open(path);
            this.inputStream = new DomainSocketInputStream();
            this.outputStream = new DomainSocketOutputStream();
        }
        catch (LastErrorException ex) {
            throw new IOException(ex);
        }
    }

    private FileDescriptor open(String path) {
        int handle = this.socket(1, 1, 0);
        this.connect(path, handle);
        return new FileDescriptor(handle, this::close);
    }

    /*
     * Loose catch block
     */
    private int read(ByteBuffer buffer) throws IOException {
        FileDescriptor.Handle handle = this.fileDescriptor.acquire();
        Throwable throwable = null;
        if (handle.isClosed()) {
            int n = -1;
            return n;
        }
        int n = this.read(handle.intValue(), buffer, buffer.remaining());
        return n;
        {
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }

    public void write(ByteBuffer buffer) throws IOException {
        block14: {
            try (FileDescriptor.Handle handle = this.fileDescriptor.acquire();){
                if (handle.isClosed()) break block14;
                try {
                    this.write(handle.intValue(), buffer, buffer.remaining());
                }
                catch (LastErrorException ex) {
                    throw new IOException(ex);
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.fileDescriptor.close();
        }
        catch (LastErrorException ex) {
            throw new IOException(ex);
        }
    }

    protected abstract void connect(String var1, int var2);

    private native int socket(int var1, int var2, int var3) throws LastErrorException;

    private native int read(int var1, ByteBuffer var2, int var3) throws LastErrorException;

    private native int write(int var1, ByteBuffer var2, int var3) throws LastErrorException;

    private native int close(int var1) throws LastErrorException;

    public static DomainSocket get(String path) throws IOException {
        if (Platform.isMac() || DomainSocket.isBsdPlatform()) {
            return new BsdDomainSocket(path);
        }
        return new LinuxDomainSocket(path);
    }

    private static boolean isBsdPlatform() {
        return Platform.isFreeBSD() || Platform.iskFreeBSD() || Platform.isNetBSD() || Platform.isOpenBSD();
    }

    static {
        Native.register(Platform.C_LIBRARY_NAME);
    }

    private class DomainSocketOutputStream
    extends OutputStream {
        private DomainSocketOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put(0, (byte)(b & 0xFF));
            DomainSocket.this.write(buffer);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len != 0) {
                DomainSocket.this.write(ByteBuffer.wrap(b, off, len));
            }
        }
    }

    private class DomainSocketInputStream
    extends InputStream {
        private DomainSocketInputStream() {
        }

        @Override
        public int read() throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            int amountRead = DomainSocket.this.read(buffer);
            return amountRead != 1 ? -1 : buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int amountRead = DomainSocket.this.read(ByteBuffer.wrap(b, off, len));
            return amountRead > 0 ? amountRead : -1;
        }
    }
}

