/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.impl;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.impl.HttpProcessors;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.RequestConformance;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.RequestExpectContinue;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.RequestUserAgent;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.ResponseConformance;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.ResponseDate;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.protocol.ResponseServer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2RequestConformance;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2RequestConnControl;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2RequestContent;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2RequestTargetHost;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2RequestValidateHost;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2ResponseConformance;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2ResponseConnControl;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http2.protocol.H2ResponseContent;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.TextUtils;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.VersionInfo;

public final class H2Processors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(ResponseConformance.INSTANCE, H2ResponseConformance.INSTANCE, ResponseDate.INSTANCE, new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "com.bmuschko.gradle.docker.shaded.org.apache.hc.core5", H2Processors.class)), H2ResponseContent.INSTANCE, H2ResponseConnControl.INSTANCE).addAll(H2RequestValidateHost.INSTANCE, H2RequestConformance.INSTANCE, RequestConformance.INSTANCE);
    }

    public static HttpProcessor server(String serverInfo) {
        return H2Processors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return H2Processors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(H2ResponseConformance.INSTANCE).addAll(H2RequestConformance.INSTANCE, H2RequestTargetHost.INSTANCE, H2RequestContent.INSTANCE, H2RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "com.bmuschko.gradle.docker.shaded.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessor client(String agentInfo) {
        return H2Processors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return H2Processors.customClient(null).build();
    }
}

