/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.compat;

import com.bmuschko.gradle.docker.shaded.org.apache.hc.client5.http.impl.compat.AbstractSharedBuffer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.annotation.Internal;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.DataStreamChannel;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.http.nio.support.classic.ContentOutputBuffer;
import com.bmuschko.gradle.docker.shaded.org.apache.hc.core5.util.Timeout;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

@Internal
final class SharedOutputBuffer
extends AbstractSharedBuffer
implements ContentOutputBuffer {
    private final AtomicBoolean endStreamPropagated = new AtomicBoolean();
    private volatile DataStreamChannel dataStreamChannel;
    private volatile boolean hasCapacity = false;

    public SharedOutputBuffer(ReentrantLock lock, int initialBufferSize) {
        super(lock, initialBufferSize);
    }

    public SharedOutputBuffer(int bufferSize) {
        this(new ReentrantLock(), bufferSize);
    }

    public void flush(DataStreamChannel channel) throws IOException {
        this.lock.lock();
        try {
            this.dataStreamChannel = channel;
            this.hasCapacity = true;
            this.setOutputMode();
            if (this.buffer().hasRemaining()) {
                this.dataStreamChannel.write(this.buffer());
            }
            if (!this.buffer().hasRemaining() && this.endStream) {
                this.propagateEndStream();
            }
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void ensureNotAborted() throws InterruptedIOException {
        if (this.aborted) {
            throw new InterruptedIOException("Operation aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len, Timeout timeout) throws IOException {
        ByteBuffer src = ByteBuffer.wrap(b, off, len);
        this.lock.lock();
        try {
            this.ensureNotAborted();
            this.setInputMode();
            while (src.hasRemaining()) {
                int bytesWritten;
                if (src.remaining() < 1024 && this.buffer().remaining() > src.remaining()) {
                    this.buffer().put(src);
                    continue;
                }
                if (this.buffer().position() > 0 || this.dataStreamChannel == null) {
                    this.waitFlush(timeout);
                }
                if (this.buffer().position() != 0 || this.dataStreamChannel == null || (bytesWritten = this.dataStreamChannel.write(src)) != 0) continue;
                this.hasCapacity = false;
                this.waitFlush(timeout);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len, null);
    }

    public void write(int b, Timeout timeout) throws IOException {
        this.lock.lock();
        try {
            this.ensureNotAborted();
            this.setInputMode();
            if (!this.buffer().hasRemaining()) {
                this.waitFlush(timeout);
            }
            this.buffer().put((byte)b);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(b, null);
    }

    public void writeCompleted(Timeout timeout) throws IOException {
        if (this.endStream) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.endStream) {
                this.endStream = true;
                if (this.dataStreamChannel != null) {
                    this.setOutputMode();
                    if (this.buffer().hasRemaining()) {
                        this.dataStreamChannel.requestOutput();
                        this.waitEndStream(timeout);
                    } else {
                        this.propagateEndStream();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void writeCompleted() throws IOException {
        this.writeCompleted(null);
    }

    private void waitFlush(Timeout timeout) throws InterruptedIOException {
        if (this.dataStreamChannel != null) {
            this.dataStreamChannel.requestOutput();
        }
        this.setOutputMode();
        while (this.buffer().hasRemaining() || !this.hasCapacity) {
            this.ensureNotAborted();
            this.waitForSignal(timeout);
        }
        this.setInputMode();
    }

    private void waitEndStream(Timeout timeout) throws InterruptedIOException {
        if (this.dataStreamChannel != null) {
            this.dataStreamChannel.requestOutput();
        }
        while (!this.endStreamPropagated.get() && !this.aborted) {
            this.waitForSignal(timeout);
        }
    }

    private void waitForSignal(Timeout timeout) throws InterruptedIOException {
        try {
            if (timeout == null) {
                this.condition.await();
            } else if (!this.condition.await(timeout.getDuration(), timeout.getTimeUnit())) {
                this.aborted = true;
                throw new InterruptedIOException("Timeout blocked waiting for output (" + timeout + ")");
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException(ex.getMessage());
        }
    }

    private void propagateEndStream() throws IOException {
        if (this.endStreamPropagated.compareAndSet(false, true)) {
            this.dataStreamChannel.endStream();
        }
    }
}

