/*
 * Decompiled with CFR 0.152.
 */
package com.bmuschko.gradle.docker.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Consumer;

public final class OutputCollector
implements Closeable {
    private final Consumer<String> output;
    private final StringBuffer buffer = new StringBuffer();

    public OutputCollector(Consumer<String> output) {
        this.output = output;
    }

    public void accept(String input) {
        String[] parts = input.split("\\R", -1);
        this.buffer.append(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            this.flushBuffer();
            this.buffer.append(parts[i]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.length() > 0) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() {
        this.output.accept(this.buffer.toString());
        this.buffer.delete(0, this.buffer.length());
    }
}

