/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.internal.TransactionIndexer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class ControllerHostedRouter
extends Router {
    private final String KEY_HOST_ID = "ControllerHostedRouter.hostId";
    private final String KEY_TAG = "ControllerHostedRouter.tag";
    private final String KEY_BOUND_TO_CONTAINER = "ControllerHostedRouter.boundToContainer";
    private Controller hostController;
    @IdRes
    private int hostId;
    private String tag;
    private boolean isDetachFrozen;
    private boolean boundToContainer;

    ControllerHostedRouter() {
    }

    ControllerHostedRouter(int hostId, @Nullable String tag, boolean boundToContainer) {
        if (!boundToContainer && tag == null) {
            throw new IllegalStateException("ControllerHostedRouter can't be created without a tag if not bounded to its container");
        }
        this.hostId = hostId;
        this.tag = tag;
        this.boundToContainer = boundToContainer;
    }

    final void setHostController(@NonNull Controller controller) {
        if (this.hostController == null) {
            this.hostController = controller;
            this.setOnBackPressedDispatcherEnabled(controller.onBackPressedDispatcherEnabled);
        }
    }

    final void setHostContainer(@NonNull Controller controller, @NonNull ViewGroup container) {
        if (this.hostController != controller || this.container != container) {
            this.removeHost();
            if (container instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.addChangeListener((ControllerChangeHandler.ControllerChangeListener)container);
            }
            this.hostController = controller;
            this.container = container;
            this.setOnBackPressedDispatcherEnabled(controller.onBackPressedDispatcherEnabled);
            for (RouterTransaction transaction : this.backstack) {
                transaction.controller().setParentController(controller);
            }
            this.watchContainerAttach();
        }
    }

    final void removeHost() {
        if (this.container != null && this.container instanceof ControllerChangeHandler.ControllerChangeListener) {
            this.removeChangeListener((ControllerChangeHandler.ControllerChangeListener)this.container);
        }
        ArrayList controllersToDestroy = new ArrayList(this.destroyingControllers);
        for (Controller controller : controllersToDestroy) {
            if (controller.getView() == null) continue;
            controller.detach(controller.getView(), true, false);
        }
        for (RouterTransaction transaction : this.backstack) {
            if (transaction.controller().getView() == null) continue;
            transaction.controller().detach(transaction.controller().getView(), true, false);
        }
        this.prepareForContainerRemoval();
        this.container = null;
    }

    final void setDetachFrozen(boolean frozen) {
        this.isDetachFrozen = frozen;
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller().setDetachFrozen(frozen);
        }
    }

    @Override
    void destroy(boolean popViews) {
        this.setDetachFrozen(false);
        super.destroy(popViews);
    }

    @Override
    protected void pushToBackstack(@NonNull RouterTransaction entry) {
        if (this.isDetachFrozen) {
            entry.controller().setDetachFrozen(true);
        }
        super.pushToBackstack(entry);
    }

    @Override
    public void setBackstack(@NonNull List<RouterTransaction> newBackstack, @Nullable ControllerChangeHandler changeHandler) {
        if (this.isDetachFrozen) {
            for (RouterTransaction transaction : newBackstack) {
                transaction.controller().setDetachFrozen(true);
            }
        }
        super.setBackstack(newBackstack, changeHandler);
    }

    @Override
    void performControllerChange(@Nullable RouterTransaction to, @Nullable RouterTransaction from, boolean isPush) {
        super.performControllerChange(to, from, isPush);
        if (to != null && !this.hostController.isAttached() && (to.pushChangeHandler() == null || to.pushChangeHandler().getRemovesFromViewOnPush())) {
            for (RouterTransaction transaction : this.backstack) {
                transaction.controller().setNeedsAttach(false);
            }
        }
    }

    @Override
    @Nullable
    public Activity getActivity() {
        return this.hostController != null ? this.hostController.getActivity() : null;
    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity, boolean isConfigurationChange) {
        super.onActivityDestroyed(activity, isConfigurationChange);
        this.removeHost();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().invalidateOptionsMenu();
        }
    }

    @Override
    void startActivity(@NonNull Intent intent) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivity(intent);
        }
    }

    @Override
    void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivityForResult(instanceId, intent, requestCode);
        }
    }

    @Override
    void startActivityForResult(@NonNull String instanceId, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivityForResult(instanceId, intent, requestCode, options);
        }
    }

    @Override
    void startIntentSenderForResult(@NonNull String instanceId, @NonNull IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startIntentSenderForResult(instanceId, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
        }
    }

    @Override
    void registerForActivityResult(@NonNull String instanceId, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().registerForActivityResult(instanceId, requestCode);
        }
    }

    @Override
    void unregisterForActivityResults(@NonNull String instanceId) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().unregisterForActivityResults(instanceId);
        }
    }

    @Override
    void requestPermissions(@NonNull String instanceId, @NonNull String[] permissions, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().requestPermissions(instanceId, permissions, requestCode);
        }
    }

    @Override
    boolean hasHost() {
        return this.hostController != null && this.container != null;
    }

    @Override
    public void saveInstanceState(@NonNull Bundle outState) {
        super.saveInstanceState(outState);
        outState.putInt("ControllerHostedRouter.hostId", this.hostId);
        outState.putBoolean("ControllerHostedRouter.boundToContainer", this.boundToContainer);
        outState.putString("ControllerHostedRouter.tag", this.tag);
    }

    @Override
    public void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.restoreInstanceState(savedInstanceState);
        this.hostId = savedInstanceState.getInt("ControllerHostedRouter.hostId");
        this.boundToContainer = savedInstanceState.getBoolean("ControllerHostedRouter.boundToContainer");
        this.tag = savedInstanceState.getString("ControllerHostedRouter.tag");
    }

    @Override
    void setRouterOnController(@NonNull Controller controller) {
        controller.setParentController(this.hostController);
        super.setRouterOnController(controller);
    }

    int getHostId() {
        return this.hostId;
    }

    boolean matches(int hostId, @Nullable String tag) {
        if (!this.boundToContainer && this.container == null) {
            if (this.tag == null) {
                throw new IllegalStateException("Host ID can't be variable with a null tag");
            }
            if (this.tag.equals(tag)) {
                this.hostId = hostId;
                return true;
            }
        }
        return this.hostId == hostId && TextUtils.equals((CharSequence)tag, (CharSequence)this.tag);
    }

    @Override
    @NonNull
    List<Router> getSiblingRouters() {
        ArrayList<Router> list = new ArrayList<Router>();
        list.addAll(this.hostController.getChildRouters());
        list.addAll(this.hostController.getRouter().getSiblingRouters());
        return list;
    }

    @Override
    @NonNull
    Router getRootRouter() {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            return this.hostController.getRouter().getRootRouter();
        }
        return this;
    }

    @Override
    @NonNull
    TransactionIndexer getTransactionIndexer() {
        Router rootRouter = this.getRootRouter();
        if (rootRouter == this) {
            String debugInfo = this.hostController != null ? String.format(Locale.ENGLISH, "%s (attached? %b, destroyed? %b, parent: %s)", this.hostController.getClass().getSimpleName(), this.hostController.isAttached(), this.hostController.isBeingDestroyed, this.hostController.getParentController()) : "null host controller";
            throw new IllegalStateException("Unable to retrieve TransactionIndexer from " + debugInfo);
        }
        return this.getRootRouter().getTransactionIndexer();
    }
}

