/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Backstack;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.ControllerChangeType;
import com.bluelinelabs.conductor.RouterTransaction;
import com.bluelinelabs.conductor.changehandler.SimpleSwapChangeHandler;
import com.bluelinelabs.conductor.internal.NoOpControllerChangeHandler;
import com.bluelinelabs.conductor.internal.ThreadUtils;
import com.bluelinelabs.conductor.internal.TransactionIndexer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class Router {
    private static final String KEY_BACKSTACK = "Router.backstack";
    private static final String KEY_POPS_LAST_VIEW = "Router.popsLastView";
    final Backstack backstack = new Backstack();
    private final List<ControllerChangeHandler.ControllerChangeListener> changeListeners = new ArrayList<ControllerChangeHandler.ControllerChangeListener>();
    private final List<ControllerChangeHandler.ChangeTransaction> pendingControllerChanges = new ArrayList<ControllerChangeHandler.ChangeTransaction>();
    final List<Controller> destroyingControllers = new ArrayList<Controller>();
    private boolean popsLastView = false;
    boolean containerFullyAttached = false;
    ViewGroup container;

    @Nullable
    public abstract Activity getActivity();

    public abstract void onActivityResult(int var1, int var2, @Nullable Intent var3);

    public void onRequestPermissionsResult(@NonNull String instanceId, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.requestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    @UiThread
    public boolean handleBack() {
        ThreadUtils.ensureMainThread();
        if (!this.backstack.isEmpty()) {
            if (this.backstack.peek().controller.handleBack()) {
                return true;
            }
            if (this.popCurrentController()) {
                return true;
            }
        }
        return false;
    }

    @UiThread
    public boolean popCurrentController() {
        ThreadUtils.ensureMainThread();
        RouterTransaction transaction = this.backstack.peek();
        if (transaction == null) {
            throw new IllegalStateException("Trying to pop the current controller when there are none on the backstack.");
        }
        return this.popController(transaction.controller);
    }

    @UiThread
    public boolean popController(@NonNull Controller controller) {
        boolean poppingTopController;
        ThreadUtils.ensureMainThread();
        RouterTransaction topTransaction = this.backstack.peek();
        boolean bl = poppingTopController = topTransaction != null && topTransaction.controller == controller;
        if (poppingTopController) {
            this.trackDestroyingController(this.backstack.pop());
            this.performControllerChange(this.backstack.peek(), topTransaction, false);
        } else {
            RouterTransaction removedTransaction = null;
            RouterTransaction nextTransaction = null;
            for (RouterTransaction transaction : this.backstack) {
                if (transaction.controller == controller) {
                    if (controller.isAttached()) {
                        this.trackDestroyingController(transaction);
                    }
                    this.backstack.remove(transaction);
                    removedTransaction = transaction;
                    continue;
                }
                if (removedTransaction == null) continue;
                if (transaction.controller.isAttached()) break;
                nextTransaction = transaction;
                break;
            }
            if (removedTransaction != null) {
                this.performControllerChange(nextTransaction, removedTransaction, false);
            }
        }
        if (this.popsLastView) {
            return topTransaction != null;
        }
        return !this.backstack.isEmpty();
    }

    @UiThread
    public void pushController(@NonNull RouterTransaction transaction) {
        ThreadUtils.ensureMainThread();
        RouterTransaction from = this.backstack.peek();
        this.pushToBackstack(transaction);
        this.performControllerChange(transaction, from, true);
    }

    @UiThread
    public void replaceTopController(@NonNull RouterTransaction transaction) {
        ThreadUtils.ensureMainThread();
        RouterTransaction topTransaction = this.backstack.peek();
        if (!this.backstack.isEmpty()) {
            this.trackDestroyingController(this.backstack.pop());
        }
        ControllerChangeHandler handler = transaction.pushChangeHandler();
        if (topTransaction != null) {
            boolean newHandlerRemovesViews;
            boolean oldHandlerRemovedViews = topTransaction.pushChangeHandler() == null || topTransaction.pushChangeHandler().removesFromViewOnPush();
            boolean bl = newHandlerRemovesViews = handler == null || handler.removesFromViewOnPush();
            if (!oldHandlerRemovedViews && newHandlerRemovesViews) {
                for (RouterTransaction visibleTransaction : this.getVisibleTransactions(this.backstack.iterator())) {
                    this.performControllerChange(null, visibleTransaction, true, handler);
                }
            }
        }
        this.pushToBackstack(transaction);
        if (handler != null) {
            handler.setForceRemoveViewOnPush(true);
        }
        this.performControllerChange(transaction.pushChangeHandler(handler), topTransaction, true);
    }

    void destroy(boolean popViews) {
        this.popsLastView = true;
        final List<RouterTransaction> poppedControllers = this.backstack.popAll();
        this.trackDestroyingControllers(poppedControllers);
        if (popViews && poppedControllers.size() > 0) {
            RouterTransaction topTransaction = poppedControllers.get(0);
            topTransaction.controller().addLifecycleListener(new Controller.LifecycleListener(){

                @Override
                public void onChangeEnd(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull ControllerChangeType changeType) {
                    if (changeType == ControllerChangeType.POP_EXIT) {
                        for (int i = poppedControllers.size() - 1; i > 0; --i) {
                            RouterTransaction transaction = (RouterTransaction)poppedControllers.get(i);
                            Router.this.performControllerChange(null, transaction, true, new SimpleSwapChangeHandler());
                        }
                    }
                }
            });
            this.performControllerChange(null, topTransaction, false, topTransaction.popChangeHandler());
        }
    }

    public int getContainerId() {
        return this.container != null ? this.container.getId() : 0;
    }

    @NonNull
    public Router setPopsLastView(boolean popsLastView) {
        this.popsLastView = popsLastView;
        return this;
    }

    @UiThread
    public boolean popToRoot() {
        ThreadUtils.ensureMainThread();
        return this.popToRoot(null);
    }

    @UiThread
    public boolean popToRoot(@Nullable ControllerChangeHandler changeHandler) {
        ThreadUtils.ensureMainThread();
        if (this.backstack.size() > 1) {
            this.popToTransaction(this.backstack.root(), changeHandler);
            return true;
        }
        return false;
    }

    @UiThread
    public boolean popToTag(@NonNull String tag) {
        ThreadUtils.ensureMainThread();
        return this.popToTag(tag, null);
    }

    @UiThread
    public boolean popToTag(@NonNull String tag, @Nullable ControllerChangeHandler changeHandler) {
        ThreadUtils.ensureMainThread();
        for (RouterTransaction transaction : this.backstack) {
            if (!tag.equals(transaction.tag())) continue;
            this.popToTransaction(transaction, changeHandler);
            return true;
        }
        return false;
    }

    @UiThread
    public void setRoot(@NonNull RouterTransaction transaction) {
        ThreadUtils.ensureMainThread();
        List<RouterTransaction> transactions = Collections.singletonList(transaction);
        this.setBackstack(transactions, transaction.pushChangeHandler());
    }

    @Nullable
    public Controller getControllerWithInstanceId(@NonNull String instanceId) {
        for (RouterTransaction transaction : this.backstack) {
            Controller controllerWithId = transaction.controller.findController(instanceId);
            if (controllerWithId == null) continue;
            return controllerWithId;
        }
        return null;
    }

    @Nullable
    public Controller getControllerWithTag(@NonNull String tag) {
        for (RouterTransaction transaction : this.backstack) {
            if (!tag.equals(transaction.tag())) continue;
            return transaction.controller;
        }
        return null;
    }

    public int getBackstackSize() {
        return this.backstack.size();
    }

    @NonNull
    public List<RouterTransaction> getBackstack() {
        ArrayList<RouterTransaction> list = new ArrayList<RouterTransaction>();
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            list.add(backstackIterator.next());
        }
        return list;
    }

    @UiThread
    public void setBackstack(@NonNull List<RouterTransaction> newBackstack, @Nullable ControllerChangeHandler changeHandler) {
        ThreadUtils.ensureMainThread();
        List<RouterTransaction> oldVisibleTransactions = this.getVisibleTransactions(this.backstack.iterator());
        boolean newRootRequiresPush = newBackstack.size() <= 0 || !this.backstack.contains(newBackstack.get(0));
        this.removeAllExceptVisibleAndUnowned();
        this.ensureOrderedTransactionIndices(newBackstack);
        this.backstack.setBackstack(newBackstack);
        for (RouterTransaction transaction : this.backstack) {
            transaction.onAttachedToRouter();
        }
        if (newBackstack.size() > 0) {
            boolean visibleTransactionsChanged;
            ArrayList<RouterTransaction> reverseNewBackstack = new ArrayList<RouterTransaction>(newBackstack);
            Collections.reverse(reverseNewBackstack);
            List<RouterTransaction> newVisibleTransactions = this.getVisibleTransactions(reverseNewBackstack.iterator());
            boolean bl = visibleTransactionsChanged = !this.backstacksAreEqual(newVisibleTransactions, oldVisibleTransactions);
            if (visibleTransactionsChanged) {
                RouterTransaction transaction;
                int i;
                RouterTransaction oldRootTransaction = oldVisibleTransactions.size() > 0 ? oldVisibleTransactions.get(0) : null;
                RouterTransaction newRootTransaction = newVisibleTransactions.get(0);
                if (oldRootTransaction == null || oldRootTransaction.controller != newRootTransaction.controller) {
                    if (oldRootTransaction != null) {
                        ControllerChangeHandler.completeHandlerImmediately(oldRootTransaction.controller.getInstanceId());
                    }
                    this.performControllerChange(newRootTransaction, oldRootTransaction, newRootRequiresPush, changeHandler);
                }
                for (i = oldVisibleTransactions.size() - 1; i > 0; --i) {
                    transaction = oldVisibleTransactions.get(i);
                    if (newVisibleTransactions.contains(transaction)) continue;
                    ControllerChangeHandler localHandler = changeHandler != null ? changeHandler.copy() : new SimpleSwapChangeHandler();
                    localHandler.setForceRemoveViewOnPush(true);
                    ControllerChangeHandler.completeHandlerImmediately(transaction.controller.getInstanceId());
                    this.performControllerChange(null, transaction, newRootRequiresPush, localHandler);
                }
                for (i = 1; i < newVisibleTransactions.size(); ++i) {
                    transaction = newVisibleTransactions.get(i);
                    if (oldVisibleTransactions.contains(transaction)) continue;
                    this.performControllerChange(transaction, newVisibleTransactions.get(i - 1), true, transaction.pushChangeHandler());
                }
            }
            for (RouterTransaction transaction : newBackstack) {
                transaction.controller.setRouter(this);
            }
        }
    }

    public boolean hasRootController() {
        return this.getBackstackSize() > 0;
    }

    public void addChangeListener(@NonNull ControllerChangeHandler.ControllerChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public void removeChangeListener(@NonNull ControllerChangeHandler.ControllerChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @UiThread
    public void rebindIfNeeded() {
        ThreadUtils.ensureMainThread();
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            if (!transaction.controller.getNeedsAttach()) continue;
            this.performControllerChange(transaction, null, true, (ControllerChangeHandler)new SimpleSwapChangeHandler(false));
        }
    }

    public final void onActivityResult(@NonNull String instanceId, int requestCode, int resultCode, @Nullable Intent data) {
        Controller controller = this.getControllerWithInstanceId(instanceId);
        if (controller != null) {
            controller.onActivityResult(requestCode, resultCode, data);
        }
    }

    public final void onActivityStarted(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityStarted(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityStarted(activity);
            }
        }
    }

    public final void onActivityResumed(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityResumed(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityResumed(activity);
            }
        }
    }

    public final void onActivityPaused(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityPaused(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityPaused(activity);
            }
        }
    }

    public final void onActivityStopped(@NonNull Activity activity) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityStopped(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityStopped(activity);
            }
        }
    }

    public void onActivityDestroyed(@NonNull Activity activity) {
        this.prepareForContainerRemoval();
        this.changeListeners.clear();
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.activityDestroyed(activity);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onActivityDestroyed(activity);
            }
        }
        for (int index = this.destroyingControllers.size() - 1; index >= 0; --index) {
            Controller controller = this.destroyingControllers.get(index);
            controller.activityDestroyed(activity);
            for (Router childRouter : controller.getChildRouters()) {
                childRouter.onActivityDestroyed(activity);
            }
        }
        this.container = null;
    }

    void prepareForHostDetach() {
        for (RouterTransaction transaction : this.backstack) {
            if (ControllerChangeHandler.completeHandlerImmediately(transaction.controller.getInstanceId())) {
                transaction.controller.setNeedsAttach(true);
            }
            transaction.controller.prepareForHostDetach();
        }
    }

    public void saveInstanceState(@NonNull Bundle outState) {
        this.prepareForHostDetach();
        Bundle backstackState = new Bundle();
        this.backstack.saveInstanceState(backstackState);
        outState.putParcelable(KEY_BACKSTACK, (Parcelable)backstackState);
        outState.putBoolean(KEY_POPS_LAST_VIEW, this.popsLastView);
    }

    public void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        Bundle backstackBundle = (Bundle)savedInstanceState.getParcelable(KEY_BACKSTACK);
        this.backstack.restoreInstanceState(backstackBundle);
        this.popsLastView = savedInstanceState.getBoolean(KEY_POPS_LAST_VIEW);
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            this.setControllerRouter(backstackIterator.next().controller);
        }
    }

    public final void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.createOptionsMenu(menu, inflater);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onCreateOptionsMenu(menu, inflater);
            }
        }
    }

    public final void onPrepareOptionsMenu(@NonNull Menu menu) {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.prepareOptionsMenu(menu);
            for (Router childRouter : transaction.controller.getChildRouters()) {
                childRouter.onPrepareOptionsMenu(menu);
            }
        }
    }

    public final boolean onOptionsItemSelected(@NonNull MenuItem item) {
        for (RouterTransaction transaction : this.backstack) {
            if (transaction.controller.optionsItemSelected(item)) {
                return true;
            }
            for (Router childRouter : transaction.controller.getChildRouters()) {
                if (!childRouter.onOptionsItemSelected(item)) continue;
                return true;
            }
        }
        return false;
    }

    private void popToTransaction(@NonNull RouterTransaction transaction, @Nullable ControllerChangeHandler changeHandler) {
        if (this.backstack.size() > 0) {
            RouterTransaction topTransaction = this.backstack.peek();
            ArrayList<RouterTransaction> updatedBackstack = new ArrayList<RouterTransaction>();
            Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
            while (backstackIterator.hasNext()) {
                RouterTransaction existingTransaction = backstackIterator.next();
                updatedBackstack.add(existingTransaction);
                if (existingTransaction != transaction) continue;
                break;
            }
            if (changeHandler == null) {
                changeHandler = topTransaction.popChangeHandler();
            }
            this.setBackstack(updatedBackstack, changeHandler);
        }
    }

    void watchContainerAttach() {
        this.container.post(new Runnable(){

            @Override
            public void run() {
                Router.this.containerFullyAttached = true;
            }
        });
    }

    void prepareForContainerRemoval() {
        this.containerFullyAttached = false;
        if (this.container != null) {
            this.container.setOnHierarchyChangeListener(null);
        }
    }

    void onContextAvailable() {
        for (RouterTransaction transaction : this.backstack) {
            transaction.controller.onContextAvailable();
        }
    }

    @NonNull
    final List<Controller> getControllers() {
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        Iterator<RouterTransaction> backstackIterator = this.backstack.reverseIterator();
        while (backstackIterator.hasNext()) {
            controllers.add(backstackIterator.next().controller);
        }
        return controllers;
    }

    @Nullable
    public final Boolean handleRequestedPermission(@NonNull String permission) {
        for (RouterTransaction transaction : this.backstack) {
            if (!transaction.controller.didRequestPermission(permission)) continue;
            return transaction.controller.shouldShowRequestPermissionRationale(permission);
        }
        return null;
    }

    private void performControllerChange(@Nullable RouterTransaction to, @Nullable RouterTransaction from, boolean isPush) {
        if (isPush && to != null) {
            to.onAttachedToRouter();
        }
        ControllerChangeHandler changeHandler = isPush ? to.pushChangeHandler() : (from != null ? from.popChangeHandler() : null);
        this.performControllerChange(to, from, isPush, changeHandler);
    }

    private void performControllerChange(@Nullable RouterTransaction to, @Nullable RouterTransaction from, boolean isPush, @Nullable ControllerChangeHandler changeHandler) {
        Controller toController = to != null ? to.controller : null;
        Controller fromController = from != null ? from.controller : null;
        boolean forceDetachDestroy = false;
        if (to != null) {
            to.ensureValidIndex(this.getTransactionIndexer());
            this.setControllerRouter(toController);
        } else if (this.backstack.size() == 0 && !this.popsLastView) {
            changeHandler = new NoOpControllerChangeHandler();
            forceDetachDestroy = true;
        }
        this.performControllerChange(toController, fromController, isPush, changeHandler);
        if (forceDetachDestroy && fromController != null && fromController.getView() != null) {
            fromController.detach(fromController.getView(), true, false);
        }
    }

    private void performControllerChange(@Nullable Controller to, @Nullable Controller from, boolean isPush, @Nullable ControllerChangeHandler changeHandler) {
        if (isPush && to != null && to.isDestroyed()) {
            throw new IllegalStateException("Trying to push a controller that has already been destroyed. (" + to.getClass().getSimpleName() + ")");
        }
        ControllerChangeHandler.ChangeTransaction transaction = new ControllerChangeHandler.ChangeTransaction(to, from, isPush, this.container, changeHandler, this.changeListeners);
        if (this.pendingControllerChanges.size() > 0) {
            this.pendingControllerChanges.add(transaction);
        } else if (from != null && (changeHandler == null || changeHandler.removesFromViewOnPush()) && !this.containerFullyAttached) {
            this.pendingControllerChanges.add(transaction);
            this.container.post(new Runnable(){

                @Override
                public void run() {
                    Router.this.performPendingControllerChanges();
                }
            });
        } else {
            ControllerChangeHandler.executeChange(transaction);
        }
    }

    void performPendingControllerChanges() {
        for (int i = 0; i < this.pendingControllerChanges.size(); ++i) {
            ControllerChangeHandler.executeChange(this.pendingControllerChanges.get(i));
        }
        this.pendingControllerChanges.clear();
    }

    protected void pushToBackstack(@NonNull RouterTransaction entry) {
        this.backstack.push(entry);
    }

    private void trackDestroyingController(@NonNull RouterTransaction transaction) {
        if (!transaction.controller.isDestroyed()) {
            this.destroyingControllers.add(transaction.controller);
            transaction.controller.addLifecycleListener(new Controller.LifecycleListener(){

                @Override
                public void postDestroy(@NonNull Controller controller) {
                    Router.this.destroyingControllers.remove(controller);
                }
            });
        }
    }

    private void trackDestroyingControllers(@NonNull List<RouterTransaction> transactions) {
        for (RouterTransaction transaction : transactions) {
            this.trackDestroyingController(transaction);
        }
    }

    private void removeAllExceptVisibleAndUnowned() {
        ArrayList<View> views = new ArrayList<View>();
        for (RouterTransaction transaction : this.getVisibleTransactions(this.backstack.iterator())) {
            if (transaction.controller.getView() == null) continue;
            views.add(transaction.controller.getView());
        }
        for (Router router : this.getSiblingRouters()) {
            if (router.container != this.container) continue;
            this.addRouterViewsToList(router, views);
        }
        int childCount = this.container.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.container.getChildAt(i);
            if (views.contains(child)) continue;
            this.container.removeView(child);
        }
    }

    private void ensureOrderedTransactionIndices(List<RouterTransaction> backstack) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (RouterTransaction transaction : backstack) {
            transaction.ensureValidIndex(this.getTransactionIndexer());
            indices.add(transaction.transactionIndex);
        }
        Collections.sort(indices);
        for (int i = 0; i < backstack.size(); ++i) {
            backstack.get((int)i).transactionIndex = (Integer)indices.get(i);
        }
    }

    private void addRouterViewsToList(@NonNull Router router, @NonNull List<View> list) {
        for (Controller controller : router.getControllers()) {
            if (controller.getView() != null) {
                list.add(controller.getView());
            }
            for (Router child : controller.getChildRouters()) {
                this.addRouterViewsToList(child, list);
            }
        }
    }

    private List<RouterTransaction> getVisibleTransactions(@NonNull Iterator<RouterTransaction> backstackIterator) {
        ArrayList<RouterTransaction> transactions = new ArrayList<RouterTransaction>();
        while (backstackIterator.hasNext()) {
            RouterTransaction transaction = backstackIterator.next();
            transactions.add(transaction);
            if (transaction.pushChangeHandler() != null && !transaction.pushChangeHandler().removesFromViewOnPush()) continue;
            break;
        }
        Collections.reverse(transactions);
        return transactions;
    }

    private boolean backstacksAreEqual(List<RouterTransaction> lhs, List<RouterTransaction> rhs) {
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (int i = 0; i < rhs.size(); ++i) {
            if (rhs.get(i).controller() == lhs.get(i).controller()) continue;
            return false;
        }
        return true;
    }

    void setControllerRouter(@NonNull Controller controller) {
        controller.setRouter(this);
        controller.onContextAvailable();
    }

    abstract void invalidateOptionsMenu();

    abstract void startActivity(@NonNull Intent var1);

    abstract void startActivityForResult(@NonNull String var1, @NonNull Intent var2, int var3);

    abstract void startActivityForResult(@NonNull String var1, @NonNull Intent var2, int var3, @Nullable Bundle var4);

    abstract void startIntentSenderForResult(@NonNull String var1, @NonNull IntentSender var2, int var3, @Nullable Intent var4, int var5, int var6, int var7, @Nullable Bundle var8) throws IntentSender.SendIntentException;

    abstract void registerForActivityResult(@NonNull String var1, int var2);

    abstract void unregisterForActivityResults(@NonNull String var1);

    abstract void requestPermissions(@NonNull String var1, @NonNull String[] var2, int var3);

    abstract boolean hasHost();

    @NonNull
    abstract List<Router> getSiblingRouters();

    @NonNull
    abstract Router getRootRouter();

    @Nullable
    abstract TransactionIndexer getTransactionIndexer();
}

