/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.lint;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;

public final class ControllerChangeHandlerIssueDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"ValidControllerChangeHandler", (String)"ControllerChangeHandler not instantiatable", (String)"Non-abstract ControllerChangeHandler instances must have a default constructor for the system to re-create them in the case of the process being killed.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(ControllerChangeHandlerIssueDetector.class, Scope.JAVA_FILE_SCOPE));

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("com.bluelinelabs.conductor.ControllerChangeHandler");
    }

    public void checkClass(JavaContext context, PsiClass declaration) {
        PsiMethod[] constructors;
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)declaration)) {
            return;
        }
        if (!evaluator.isPublic((PsiModifierListOwner)declaration)) {
            String message = String.format("This ControllerChangeHandler class should be public (%1$s)", declaration.getQualifiedName());
            context.report(ISSUE, (PsiElement)declaration, context.getLocation((PsiElement)declaration), message);
            return;
        }
        if (declaration.getContainingClass() != null && !evaluator.isStatic((PsiModifierListOwner)declaration)) {
            String message = String.format("This ControllerChangeHandler inner class should be static (%1$s)", declaration.getQualifiedName());
            context.report(ISSUE, (PsiElement)declaration, context.getLocation((PsiElement)declaration), message);
            return;
        }
        boolean hasDefaultConstructor = false;
        for (PsiMethod constructor : constructors = declaration.getConstructors()) {
            if (!evaluator.isPublic((PsiModifierListOwner)constructor) || constructor.getParameterList().getParametersCount() != 0) continue;
            hasDefaultConstructor = true;
            break;
        }
        if (constructors.length > 0 && !hasDefaultConstructor) {
            String message = String.format("This ControllerChangeHandler needs to have a public default constructor (`%1$s`)", declaration.getQualifiedName());
            context.report(ISSUE, (PsiElement)declaration, context.getLocation((PsiElement)declaration), message);
        }
    }
}

