/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.changehandler;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;

public abstract class AnimatorChangeHandler
extends ControllerChangeHandler {
    private static final String KEY_DURATION = "AnimatorChangeHandler.duration";
    private static final String KEY_REMOVES_FROM_ON_PUSH = "AnimatorChangeHandler.removesFromViewOnPush";
    public static final long DEFAULT_ANIMATION_DURATION = -1L;
    private long animationDuration;
    private boolean removesFromViewOnPush;
    private boolean canceled;
    private boolean needsImmediateCompletion;
    private Animator animator;

    public AnimatorChangeHandler() {
        this(-1L, true);
    }

    public AnimatorChangeHandler(boolean removesFromViewOnPush) {
        this(-1L, removesFromViewOnPush);
    }

    public AnimatorChangeHandler(long duration) {
        this(duration, true);
    }

    public AnimatorChangeHandler(long duration, boolean removesFromViewOnPush) {
        this.animationDuration = duration;
        this.removesFromViewOnPush = removesFromViewOnPush;
    }

    @Override
    public void saveToBundle(@NonNull Bundle bundle) {
        super.saveToBundle(bundle);
        bundle.putLong(KEY_DURATION, this.animationDuration);
        bundle.putBoolean(KEY_REMOVES_FROM_ON_PUSH, this.removesFromViewOnPush);
    }

    @Override
    public void restoreFromBundle(@NonNull Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.animationDuration = bundle.getLong(KEY_DURATION);
        this.removesFromViewOnPush = bundle.getBoolean(KEY_REMOVES_FROM_ON_PUSH);
    }

    @Override
    public void onAbortPush(@NonNull ControllerChangeHandler newHandler, Controller newTop) {
        super.onAbortPush(newHandler, newTop);
        this.canceled = true;
        if (this.animator != null) {
            this.animator.cancel();
        }
    }

    @Override
    public void completeImmediately() {
        super.completeImmediately();
        this.needsImmediateCompletion = true;
        if (this.animator != null) {
            this.animator.cancel();
        }
    }

    public long getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    public boolean removesFromViewOnPush() {
        return this.removesFromViewOnPush;
    }

    protected abstract Animator getAnimator(@NonNull ViewGroup var1, View var2, View var3, boolean var4, boolean var5);

    protected abstract void resetFromView(@NonNull View var1);

    @Override
    public final void performChange(final @NonNull ViewGroup container, final View from, final View to, final boolean isPush, final @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        boolean addingToView;
        boolean readyToAnimate = true;
        boolean bl = addingToView = to != null && to.getParent() == null;
        if (addingToView) {
            if (isPush || from == null) {
                container.addView(to);
            } else if (to.getParent() == null) {
                container.addView(to, container.indexOfChild(from));
            }
            if (to.getWidth() <= 0 && to.getHeight() <= 0) {
                readyToAnimate = false;
                to.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        ViewTreeObserver observer = to.getViewTreeObserver();
                        if (observer.isAlive()) {
                            observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        }
                        AnimatorChangeHandler.this.performAnimation(container, from, to, isPush, addingToView, changeListener);
                        return true;
                    }
                });
            }
        }
        if (readyToAnimate) {
            this.performAnimation(container, from, to, isPush, addingToView, changeListener);
        }
    }

    private void performAnimation(final @NonNull ViewGroup container, final View from, View to, final boolean isPush, boolean toAddedToContainer, final @NonNull ControllerChangeHandler.ControllerChangeCompletedListener changeListener) {
        if (this.canceled) {
            changeListener.onChangeCompleted();
            return;
        }
        this.animator = this.getAnimator(container, from, to, isPush, toAddedToContainer);
        if (this.animationDuration > 0L) {
            this.animator.setDuration(this.animationDuration);
        }
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                if (from != null && (!isPush || AnimatorChangeHandler.this.removesFromViewOnPush) && AnimatorChangeHandler.this.needsImmediateCompletion) {
                    container.removeView(from);
                }
                changeListener.onChangeCompleted();
                AnimatorChangeHandler.this.animator.removeListener((Animator.AnimatorListener)this);
                AnimatorChangeHandler.this.animator = null;
            }

            public void onAnimationEnd(Animator animation) {
                if (!(from == null || isPush && !AnimatorChangeHandler.this.removesFromViewOnPush || AnimatorChangeHandler.this.canceled)) {
                    container.removeView(from);
                }
                changeListener.onChangeCompleted();
                AnimatorChangeHandler.this.animator.removeListener((Animator.AnimatorListener)this);
                if (isPush && from != null) {
                    AnimatorChangeHandler.this.resetFromView(from);
                }
                AnimatorChangeHandler.this.animator = null;
            }
        });
        this.animator.start();
    }
}

