/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.ActivityHostedRouter;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.internal.StringSparseArrayParceler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LifecycleHandler
extends Fragment
implements Application.ActivityLifecycleCallbacks {
    private static final String FRAGMENT_TAG = "LifecycleHandler";
    private static final String KEY_PERMISSION_REQUEST_CODES = "LifecycleHandler.permissionRequests";
    private static final String KEY_ACTIVITY_REQUEST_CODES = "LifecycleHandler.activityRequests";
    private Activity activity;
    private boolean hasRegisteredCallbacks;
    private boolean destroyed;
    private SparseArray<String> permissionRequestMap = new SparseArray();
    private SparseArray<String> activityRequestMap = new SparseArray();
    private final Map<Integer, ActivityHostedRouter> routerMap = new HashMap<Integer, ActivityHostedRouter>();

    public LifecycleHandler() {
        this.setRetainInstance(true);
        this.setHasOptionsMenu(true);
    }

    private static LifecycleHandler findInActivity(Activity activity) {
        LifecycleHandler lifecycleHandler = (LifecycleHandler)activity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG);
        if (lifecycleHandler != null) {
            lifecycleHandler.registerActivityListener(activity);
        }
        return lifecycleHandler;
    }

    public static LifecycleHandler install(Activity activity) {
        LifecycleHandler lifecycleHandler = LifecycleHandler.findInActivity(activity);
        if (lifecycleHandler == null) {
            lifecycleHandler = new LifecycleHandler();
            activity.getFragmentManager().beginTransaction().add((Fragment)lifecycleHandler, FRAGMENT_TAG).commit();
        }
        lifecycleHandler.registerActivityListener(activity);
        return lifecycleHandler;
    }

    public Router getRouter(ViewGroup container, Bundle savedInstanceState) {
        ActivityHostedRouter router = this.routerMap.get(LifecycleHandler.getRouterHashKey(container));
        if (router == null) {
            router = new ActivityHostedRouter();
            router.setHost(this, container);
            if (savedInstanceState != null) {
                router.restoreInstanceState(savedInstanceState);
            }
            this.routerMap.put(LifecycleHandler.getRouterHashKey(container), router);
        } else {
            router.setHost(this, container);
        }
        return router;
    }

    public List<Router> getRouters() {
        return new ArrayList<Router>(this.routerMap.values());
    }

    public Activity getLifecycleActivity() {
        return this.activity;
    }

    private static int getRouterHashKey(ViewGroup viewGroup) {
        return viewGroup.getId();
    }

    private void registerActivityListener(Activity activity) {
        this.activity = activity;
        if (!this.hasRegisteredCallbacks) {
            this.hasRegisteredCallbacks = true;
            activity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            StringSparseArrayParceler permissionParcel = (StringSparseArrayParceler)savedInstanceState.getParcelable(KEY_PERMISSION_REQUEST_CODES);
            this.permissionRequestMap = permissionParcel != null ? permissionParcel.getStringSparseArray() : null;
            StringSparseArrayParceler activityParcel = (StringSparseArrayParceler)savedInstanceState.getParcelable(KEY_ACTIVITY_REQUEST_CODES);
            this.activityRequestMap = activityParcel != null ? activityParcel.getStringSparseArray() : null;
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_PERMISSION_REQUEST_CODES, (Parcelable)new StringSparseArrayParceler(this.permissionRequestMap));
        outState.putParcelable(KEY_ACTIVITY_REQUEST_CODES, (Parcelable)new StringSparseArrayParceler(this.activityRequestMap));
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.activity != null) {
            this.activity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.destroyRouters();
            this.activity = null;
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.destroyed = false;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.destroyed = false;
    }

    public void onDetach() {
        super.onDetach();
        this.destroyRouters();
    }

    private void destroyRouters() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.activity != null) {
                for (Router router : this.routerMap.values()) {
                    router.onActivityDestroyed(this.activity);
                }
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        String instanceId = (String)this.activityRequestMap.get(requestCode);
        if (instanceId != null) {
            for (Router router : this.routerMap.values()) {
                router.onActivityResult(instanceId, requestCode, resultCode, data);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        String instanceId = (String)this.permissionRequestMap.get(requestCode);
        if (instanceId != null) {
            for (Router router : this.routerMap.values()) {
                router.onRequestPermissionsResult(instanceId, requestCode, permissions, grantResults);
            }
        }
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        for (Router router : this.routerMap.values()) {
            Boolean handled = router.handleRequestedPermission(permission);
            if (handled == null) continue;
            return handled;
        }
        return super.shouldShowRequestPermissionRationale(permission);
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
        for (Router router : this.routerMap.values()) {
            router.onCreateOptionsMenu(menu, inflater);
        }
    }

    public void onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        for (Router router : this.routerMap.values()) {
            router.onPrepareOptionsMenu(menu);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        for (Router router : this.routerMap.values()) {
            if (!router.onOptionsItemSelected(item)) continue;
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void registerForActivityResult(String instanceId, int requestCode) {
        this.activityRequestMap.put(requestCode, (Object)instanceId);
    }

    public void unregisterForActivityResults(String instanceId) {
        for (int i = this.activityRequestMap.size() - 1; i >= 0; --i) {
            if (!instanceId.equals(this.activityRequestMap.get(this.activityRequestMap.keyAt(i)))) continue;
            this.activityRequestMap.removeAt(i);
        }
    }

    public void startActivityForResult(String instanceId, Intent intent, int requestCode) {
        this.registerForActivityResult(instanceId, requestCode);
        this.startActivityForResult(intent, requestCode);
    }

    public void startActivityForResult(String instanceId, Intent intent, int requestCode, Bundle options) {
        this.registerForActivityResult(instanceId, requestCode);
        this.startActivityForResult(intent, requestCode, options);
    }

    @TargetApi(value=23)
    public void requestPermissions(String instanceId, String[] permissions, int requestCode) {
        this.permissionRequestMap.put(requestCode, (Object)instanceId);
        this.requestPermissions(permissions, requestCode);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.activity == null && LifecycleHandler.findInActivity(activity) == this) {
            this.activity = activity;
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityStarted(activity);
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityResumed(activity);
            }
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityPaused(activity);
            }
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.onActivityStopped(activity);
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (this.activity == activity) {
            for (Router router : this.routerMap.values()) {
                router.saveInstanceState(outState);
            }
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

