/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.RouterTransaction;
import java.util.ArrayList;
import java.util.List;

public class ControllerHostedRouter
extends Router {
    private final String KEY_HOST_ID = "ControllerHostedRouter.hostId";
    private final String KEY_TAG = "ControllerHostedRouter.tag";
    private Controller hostController;
    @IdRes
    private int hostId;
    private String tag;

    public ControllerHostedRouter() {
    }

    public ControllerHostedRouter(int hostId, String tag) {
        this.hostId = hostId;
        this.tag = tag;
    }

    public final void setHost(@NonNull Controller controller, @NonNull ViewGroup container) {
        if (this.hostController != controller || this.container != container) {
            this.removeHost();
            if (container instanceof ControllerChangeHandler.ControllerChangeListener) {
                this.addChangeListener((ControllerChangeHandler.ControllerChangeListener)container);
            }
            this.hostController = controller;
            this.container = container;
        }
    }

    public final void removeHost() {
        if (this.container != null && this.container instanceof ControllerChangeHandler.ControllerChangeListener) {
            this.removeChangeListener((ControllerChangeHandler.ControllerChangeListener)this.container);
        }
        this.prepareForContainerRemoval();
        this.hostController = null;
        this.container = null;
    }

    public final void setDetachFrozen(boolean frozen) {
        for (RouterTransaction transaction : this.backStack) {
            transaction.controller.setDetachFrozen(frozen);
        }
    }

    @Override
    public Activity getActivity() {
        return this.hostController != null ? this.hostController.getActivity() : null;
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        super.onActivityDestroyed(activity);
        this.removeHost();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void invalidateOptionsMenu() {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().invalidateOptionsMenu();
        }
    }

    @Override
    void startActivity(Intent intent) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivity(intent);
        }
    }

    @Override
    void startActivityForResult(String instanceId, Intent intent, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivityForResult(instanceId, intent, requestCode);
        }
    }

    @Override
    void startActivityForResult(String instanceId, Intent intent, int requestCode, Bundle options) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().startActivityForResult(instanceId, intent, requestCode, options);
        }
    }

    @Override
    void registerForActivityResult(String instanceId, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().registerForActivityResult(instanceId, requestCode);
        }
    }

    @Override
    void unregisterForActivityResults(String instanceId) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().unregisterForActivityResults(instanceId);
        }
    }

    @Override
    void requestPermissions(String instanceId, String[] permissions, int requestCode) {
        if (this.hostController != null && this.hostController.getRouter() != null) {
            this.hostController.getRouter().requestPermissions(instanceId, permissions, requestCode);
        }
    }

    @Override
    boolean hasHost() {
        return this.hostController != null;
    }

    @Override
    public void saveInstanceState(Bundle outState) {
        super.saveInstanceState(outState);
        outState.putInt("ControllerHostedRouter.hostId", this.hostId);
        outState.putString("ControllerHostedRouter.tag", this.tag);
    }

    @Override
    public void restoreInstanceState(Bundle savedInstanceState) {
        super.restoreInstanceState(savedInstanceState);
        this.hostId = savedInstanceState.getInt("ControllerHostedRouter.hostId");
        this.tag = savedInstanceState.getString("ControllerHostedRouter.tag");
    }

    @Override
    void setControllerRouter(Controller controller) {
        super.setControllerRouter(controller);
        controller.setParentController(this.hostController);
    }

    public int getHostId() {
        return this.hostId;
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    List<Router> getSiblingRouters() {
        ArrayList<Router> list = new ArrayList<Router>();
        list.addAll(this.hostController.getChildRouters());
        list.addAll(this.hostController.getRouter().getSiblingRouters());
        return list;
    }
}

