/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.bluelinelabs.conductor.ControllerChangeHandler;
import com.bluelinelabs.conductor.ControllerChangeType;
import com.bluelinelabs.conductor.ControllerHostedRouter;
import com.bluelinelabs.conductor.Router;
import com.bluelinelabs.conductor.internal.ClassUtils;
import com.bluelinelabs.conductor.internal.RouterRequiringFunc;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public abstract class Controller {
    private static final String KEY_CLASS_NAME = "Controller.className";
    private static final String KEY_VIEW_STATE = "Controller.viewState";
    private static final String KEY_CHILD_ROUTERS = "Controller.childRouters";
    private static final String KEY_SAVED_STATE = "Controller.savedState";
    private static final String KEY_INSTANCE_ID = "Controller.instanceId";
    private static final String KEY_TARGET_INSTANCE_ID = "Controller.target.instanceId";
    private static final String KEY_ARGS = "Controller.args";
    private static final String KEY_NEEDS_ATTACH = "Controller.needsAttach";
    private static final String KEY_REQUESTED_PERMISSIONS = "Controller.requestedPermissions";
    private static final String KEY_OVERRIDDEN_PUSH_HANDLER = "Controller.overriddenPushHandler";
    private static final String KEY_OVERRIDDEN_POP_HANDLER = "Controller.overriddenPopHandler";
    private static final String KEY_VIEW_STATE_HIERARCHY = "Controller.viewState.hierarchy";
    private static final String KEY_VIEW_STATE_BUNDLE = "Controller.viewState.bundle";
    private final Bundle args;
    private Bundle viewState;
    private Bundle savedInstanceState;
    private boolean isBeingDestroyed;
    private boolean destroyed;
    private boolean attached;
    private boolean hasOptionsMenu;
    private boolean optionsMenuHidden;
    private boolean viewIsAttached;
    private boolean viewWasDetached;
    private Router router;
    private View view;
    private Controller parentController;
    private String instanceId;
    private String targetInstanceId;
    private boolean needsAttach;
    private boolean hasSavedViewState;
    private boolean isDetachFrozen;
    private ControllerChangeHandler overriddenPushHandler;
    private ControllerChangeHandler overriddenPopHandler;
    private RetainViewMode retainViewMode = RetainViewMode.RELEASE_DETACH;
    private View.OnAttachStateChangeListener onAttachStateChangeListener;
    private final List<ControllerHostedRouter> childRouters = new ArrayList<ControllerHostedRouter>();
    private final List<LifecycleListener> lifecycleListeners = new ArrayList<LifecycleListener>();
    private final ArrayList<String> requestedPermissions = new ArrayList();
    private final ArrayList<RouterRequiringFunc> onRouterSetListeners = new ArrayList();
    private final Deque<Controller> childBackstack = new ArrayDeque<Controller>();
    private final ControllerChangeHandler.ControllerChangeListener childRouterChangeListener = new ControllerChangeHandler.ControllerChangeListener(){

        @Override
        public void onChangeStarted(Controller to, Controller from, boolean isPush, ViewGroup container, ControllerChangeHandler handler) {
            if (isPush) {
                Controller.this.onChildControllerPushed(to);
            }
        }

        @Override
        public void onChangeCompleted(Controller to, Controller from, boolean isPush, ViewGroup container, ControllerChangeHandler handler) {
        }
    };

    static Controller newInstance(Bundle bundle) {
        Controller controller;
        String className = bundle.getString(KEY_CLASS_NAME);
        Constructor[] constructors = ClassUtils.classForName(className, false).getConstructors();
        Constructor bundleConstructor = Controller.getBundleConstructor(constructors);
        try {
            controller = bundleConstructor != null ? (Controller)bundleConstructor.newInstance(bundle.getBundle(KEY_ARGS)) : (Controller)Controller.getDefaultConstructor(constructors).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while creating a new instance of " + className + ". " + e.getMessage());
        }
        controller.restoreInstanceState(bundle);
        return controller;
    }

    protected Controller() {
        this(null);
    }

    protected Controller(Bundle args) {
        this.args = args;
        this.instanceId = UUID.randomUUID().toString();
        this.ensureRequiredConstructor();
    }

    @NonNull
    protected abstract View onCreateView(@NonNull LayoutInflater var1, @NonNull ViewGroup var2);

    public final Router getRouter() {
        return this.router;
    }

    public Bundle getArgs() {
        return this.args;
    }

    public final Router getChildRouter(@NonNull ViewGroup container, String tag) {
        int containerId = container.getId();
        ControllerHostedRouter childRouter = null;
        for (ControllerHostedRouter router : this.childRouters) {
            if (router.getHostId() != containerId || !TextUtils.equals((CharSequence)tag, (CharSequence)router.getTag())) continue;
            childRouter = router;
            break;
        }
        if (childRouter == null) {
            childRouter = new ControllerHostedRouter(container.getId(), tag);
            this.monitorChildRouter(childRouter);
            childRouter.setHost(this, container);
            this.childRouters.add(childRouter);
        } else if (!childRouter.hasHost()) {
            childRouter.setHost(this, container);
            this.monitorChildRouter(childRouter);
            childRouter.rebindIfNeeded();
        }
        return childRouter;
    }

    public final void removeChildRouter(@NonNull Router childRouter) {
        if (childRouter instanceof ControllerHostedRouter && this.childRouters.remove(childRouter)) {
            childRouter.destroy();
        }
    }

    public final boolean isDestroyed() {
        return this.destroyed;
    }

    public final boolean isBeingDestroyed() {
        return this.isBeingDestroyed;
    }

    public final boolean isAttached() {
        return this.attached;
    }

    public final View getView() {
        return this.view;
    }

    public final Activity getActivity() {
        return this.router.getActivity();
    }

    public final Resources getResources() {
        Activity activity = this.getActivity();
        return activity != null ? activity.getResources() : null;
    }

    public final Context getApplicationContext() {
        Activity activity = this.getActivity();
        return activity != null ? activity.getApplicationContext() : null;
    }

    public final Controller getParentController() {
        return this.parentController;
    }

    public final String getInstanceId() {
        return this.instanceId;
    }

    final Controller findController(String instanceId) {
        if (this.instanceId.equals(instanceId)) {
            return this;
        }
        for (Router router : this.childRouters) {
            Controller matchingChild = router.getControllerWithInstanceId(instanceId);
            if (matchingChild == null) continue;
            return matchingChild;
        }
        return null;
    }

    public final List<Router> getChildRouters() {
        ArrayList<Router> routers = new ArrayList<Router>();
        for (Router router : this.childRouters) {
            routers.add(router);
        }
        return routers;
    }

    public void setTargetController(Controller target) {
        if (this.targetInstanceId != null) {
            throw new RuntimeException("Target controller already set. A controller's target may only be set once.");
        }
        this.targetInstanceId = target != null ? target.getInstanceId() : null;
    }

    public final Controller getTargetController() {
        return this.targetInstanceId != null ? this.router.getControllerWithInstanceId(this.targetInstanceId) : null;
    }

    protected void onDestroyView(View view) {
    }

    protected void onChangeStarted(@NonNull ControllerChangeHandler changeHandler, @NonNull ControllerChangeType changeType) {
    }

    protected void onChangeEnded(@NonNull ControllerChangeHandler changeHandler, @NonNull ControllerChangeType changeType) {
    }

    protected void onAttach(@NonNull View view) {
    }

    protected void onDetach(@NonNull View view) {
    }

    protected void onDestroy() {
    }

    protected void onActivityStarted(Activity activity) {
    }

    protected void onActivityResumed(Activity activity) {
    }

    protected void onActivityPaused(Activity activity) {
    }

    protected void onActivityStopped(Activity activity) {
    }

    protected void onSaveViewState(@NonNull View view, @NonNull Bundle outState) {
    }

    protected void onRestoreViewState(@NonNull View view, @NonNull Bundle savedViewState) {
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
    }

    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
    }

    public final void startActivity(final Intent intent) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.router.startActivity(intent);
            }
        });
    }

    public final void startActivityForResult(final Intent intent, final int requestCode) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.router.startActivityForResult(Controller.this.instanceId, intent, requestCode);
            }
        });
    }

    public final void startActivityForResult(final Intent intent, final int requestCode, final Bundle options) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.router.startActivityForResult(Controller.this.instanceId, intent, requestCode, options);
            }
        });
    }

    public final void registerForActivityResult(final int requestCode) {
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.router.registerForActivityResult(Controller.this.instanceId, requestCode);
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    @TargetApi(value=23)
    public final void requestPermissions(final @NonNull String[] permissions, final int requestCode) {
        this.requestedPermissions.addAll(Arrays.asList(permissions));
        this.executeWithRouter(new RouterRequiringFunc(){

            @Override
            public void execute() {
                Controller.this.router.requestPermissions(Controller.this.instanceId, permissions, requestCode);
            }
        });
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission) {
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    public boolean handleBack() {
        Iterator<Controller> childIterator = this.childBackstack.descendingIterator();
        while (childIterator.hasNext()) {
            Controller childController = childIterator.next();
            if (!childController.isAttached() || !childController.getRouter().handleBack()) continue;
            return true;
        }
        return false;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        if (!this.lifecycleListeners.contains(lifecycleListener)) {
            this.lifecycleListeners.add(lifecycleListener);
        }
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycleListeners.remove(lifecycleListener);
    }

    public RetainViewMode getRetainViewMode() {
        return this.retainViewMode;
    }

    public void setRetainViewMode(RetainViewMode retainViewMode) {
        this.retainViewMode = retainViewMode;
        if (this.retainViewMode == RetainViewMode.RELEASE_DETACH && !this.attached) {
            this.removeViewReference();
        }
    }

    public final ControllerChangeHandler getOverriddenPushHandler() {
        return this.overriddenPushHandler;
    }

    public void overridePushHandler(ControllerChangeHandler overriddenPushHandler) {
        this.overriddenPushHandler = overriddenPushHandler;
    }

    public ControllerChangeHandler getOverriddenPopHandler() {
        return this.overriddenPopHandler;
    }

    public void overridePopHandler(ControllerChangeHandler overriddenPopHandler) {
        this.overriddenPopHandler = overriddenPopHandler;
    }

    public final void setHasOptionsMenu(boolean hasOptionsMenu) {
        boolean invalidate = this.attached && !this.optionsMenuHidden && this.hasOptionsMenu != hasOptionsMenu;
        this.hasOptionsMenu = hasOptionsMenu;
        if (invalidate) {
            this.router.invalidateOptionsMenu();
        }
    }

    public final void setOptionsMenuHidden(boolean optionsMenuHidden) {
        boolean invalidate = this.attached && this.hasOptionsMenu && this.optionsMenuHidden != optionsMenuHidden;
        this.optionsMenuHidden = optionsMenuHidden;
        if (invalidate) {
            this.router.invalidateOptionsMenu();
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
    }

    public void onPrepareOptionsMenu(Menu menu) {
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    final void prepareForHostDetach() {
        this.needsAttach = this.needsAttach || this.attached;
        for (ControllerHostedRouter router : this.childRouters) {
            router.prepareForHostDetach();
        }
    }

    final boolean getNeedsAttach() {
        return this.needsAttach;
    }

    final boolean didRequestPermission(@NonNull String permission) {
        return this.requestedPermissions.contains(permission);
    }

    final void requestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.requestedPermissions.removeAll(Arrays.asList(permissions));
        this.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    final void setRouter(@NonNull Router router) {
        if (this.router != router) {
            this.router = router;
            this.performOnRestoreInstanceState();
            for (RouterRequiringFunc listener : this.onRouterSetListeners) {
                listener.execute();
            }
            this.onRouterSetListeners.clear();
        } else {
            this.performOnRestoreInstanceState();
        }
    }

    final void executeWithRouter(@NonNull RouterRequiringFunc listener) {
        if (this.router != null) {
            listener.execute();
        } else {
            this.onRouterSetListeners.add(listener);
        }
    }

    final void activityStarted(Activity activity) {
        this.onActivityStarted(activity);
    }

    final void activityResumed(Activity activity) {
        if (!this.attached && this.view != null && this.viewIsAttached) {
            this.attach(this.view);
        }
        this.onActivityResumed(activity);
    }

    final void activityPaused(Activity activity) {
        this.onActivityPaused(activity);
    }

    final void activityStopped(Activity activity) {
        this.onActivityStopped(activity);
    }

    final void activityDestroyed(boolean isChangingConfigurations) {
        if (isChangingConfigurations) {
            this.detach(this.view, true);
        } else {
            this.destroy(true);
        }
    }

    private void attach(@NonNull View view) {
        this.hasSavedViewState = false;
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.preAttach(this, view);
        }
        this.attached = true;
        this.needsAttach = false;
        this.onAttach(view);
        if (this.hasOptionsMenu && !this.optionsMenuHidden) {
            this.router.invalidateOptionsMenu();
        }
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.postAttach(this, view);
        }
    }

    private void detach(@NonNull View view, boolean forceViewRefRemoval) {
        boolean removeViewRef;
        for (ControllerHostedRouter router : this.childRouters) {
            router.prepareForHostDetach();
        }
        boolean bl = removeViewRef = forceViewRefRemoval || this.retainViewMode == RetainViewMode.RELEASE_DETACH || this.isBeingDestroyed;
        if (this.attached) {
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.preDetach(this, view);
            }
            this.attached = false;
            this.onDetach(view);
            if (this.hasOptionsMenu && !this.optionsMenuHidden) {
                this.router.invalidateOptionsMenu();
            }
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.postDetach(this, view);
            }
        }
        if (removeViewRef) {
            this.removeViewReference();
        }
    }

    private void removeViewReference() {
        if (this.view != null) {
            if (!this.isBeingDestroyed && !this.hasSavedViewState) {
                this.saveViewState(this.view);
            }
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.preDestroyView(this, this.view);
            }
            this.onDestroyView(this.view);
            this.view.removeOnAttachStateChangeListener(this.onAttachStateChangeListener);
            this.viewIsAttached = false;
            this.view = null;
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.postDestroyView(this);
            }
            for (ControllerHostedRouter childRouter : this.childRouters) {
                childRouter.removeHost();
            }
        }
        if (this.isBeingDestroyed) {
            this.performDestroy();
        }
    }

    final View inflate(@NonNull ViewGroup parent) {
        if (this.view != null && this.view.getParent() != null && this.view.getParent() != parent) {
            this.detach(this.view, true);
            this.removeViewReference();
        }
        if (this.view == null) {
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.preCreateView(this);
            }
            this.view = this.onCreateView(LayoutInflater.from((Context)parent.getContext()), parent);
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.postCreateView(this, this.view);
            }
            this.restoreViewState(this.view);
            this.onAttachStateChangeListener = new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    if (v == Controller.this.view) {
                        Controller.this.viewIsAttached = true;
                        Controller.this.viewWasDetached = false;
                    }
                    Controller.this.attach(v);
                }

                public void onViewDetachedFromWindow(View v) {
                    Controller.this.viewIsAttached = false;
                    Controller.this.viewWasDetached = true;
                    if (!Controller.this.isDetachFrozen) {
                        Controller.this.detach(v, false);
                    }
                }
            };
            this.view.addOnAttachStateChangeListener(this.onAttachStateChangeListener);
        }
        return this.view;
    }

    final void performDestroy() {
        if (!this.destroyed) {
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.preDestroy(this);
            }
            this.destroyed = true;
            if (this.router != null) {
                this.router.unregisterForActivityResults(this.instanceId);
            }
            this.onDestroy();
            this.parentController = null;
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.postDestroy(this);
            }
        }
    }

    final void destroy() {
        this.destroy(false);
    }

    final void destroy(boolean removeViews) {
        this.isBeingDestroyed = true;
        for (ControllerHostedRouter childRouter : this.childRouters) {
            childRouter.destroy();
        }
        if (!this.attached) {
            this.removeViewReference();
        } else if (removeViews) {
            this.detach(this.view, false);
        }
    }

    final void saveViewState(@NonNull View view) {
        this.hasSavedViewState = true;
        this.viewState = new Bundle();
        SparseArray hierarchyState = new SparseArray();
        view.saveHierarchyState(hierarchyState);
        this.viewState.putSparseParcelableArray(KEY_VIEW_STATE_HIERARCHY, hierarchyState);
        Bundle stateBundle = new Bundle();
        this.onSaveViewState(view, stateBundle);
        this.viewState.putBundle(KEY_VIEW_STATE_BUNDLE, stateBundle);
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onSaveViewState(this, this.viewState);
        }
    }

    final void restoreViewState(@NonNull View view) {
        if (this.viewState != null) {
            view.restoreHierarchyState(this.viewState.getSparseParcelableArray(KEY_VIEW_STATE_HIERARCHY));
            this.onRestoreViewState(view, this.viewState.getBundle(KEY_VIEW_STATE_BUNDLE));
            for (ControllerHostedRouter childRouter : this.childRouters) {
                View containerView;
                if (childRouter.hasHost() || (containerView = view.findViewById(childRouter.getHostId())) == null || !(containerView instanceof ViewGroup)) continue;
                childRouter.setHost(this, (ViewGroup)containerView);
                childRouter.rebindIfNeeded();
            }
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onRestoreViewState(this, this.viewState);
            }
        }
    }

    final Bundle saveInstanceState() {
        if (!this.hasSavedViewState && this.view != null) {
            this.saveViewState(this.view);
        }
        Bundle outState = new Bundle();
        outState.putString(KEY_CLASS_NAME, this.getClass().getName());
        outState.putBundle(KEY_VIEW_STATE, this.viewState);
        outState.putBundle(KEY_ARGS, this.args);
        outState.putString(KEY_INSTANCE_ID, this.instanceId);
        outState.putString(KEY_TARGET_INSTANCE_ID, this.targetInstanceId);
        outState.putStringArrayList(KEY_REQUESTED_PERMISSIONS, this.requestedPermissions);
        outState.putBoolean(KEY_NEEDS_ATTACH, this.needsAttach || this.attached);
        if (this.overriddenPushHandler != null) {
            outState.putBundle(KEY_OVERRIDDEN_PUSH_HANDLER, this.overriddenPushHandler.toBundle());
        }
        if (this.overriddenPopHandler != null) {
            outState.putBundle(KEY_OVERRIDDEN_POP_HANDLER, this.overriddenPopHandler.toBundle());
        }
        ArrayList<Bundle> childBundles = new ArrayList<Bundle>();
        for (ControllerHostedRouter childRouter : this.childRouters) {
            Bundle routerBundle = new Bundle();
            childRouter.saveInstanceState(routerBundle);
            childBundles.add(routerBundle);
        }
        outState.putParcelableArrayList(KEY_CHILD_ROUTERS, childBundles);
        Bundle savedState = new Bundle();
        this.onSaveInstanceState(savedState);
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onSaveInstanceState(this, savedState);
        }
        outState.putBundle(KEY_SAVED_STATE, savedState);
        return outState;
    }

    private void restoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.viewState = savedInstanceState.getBundle(KEY_VIEW_STATE);
        this.instanceId = savedInstanceState.getString(KEY_INSTANCE_ID);
        this.targetInstanceId = savedInstanceState.getString(KEY_TARGET_INSTANCE_ID);
        this.requestedPermissions.addAll(savedInstanceState.getStringArrayList(KEY_REQUESTED_PERMISSIONS));
        this.overriddenPushHandler = ControllerChangeHandler.fromBundle(savedInstanceState.getBundle(KEY_OVERRIDDEN_PUSH_HANDLER));
        this.overriddenPopHandler = ControllerChangeHandler.fromBundle(savedInstanceState.getBundle(KEY_OVERRIDDEN_POP_HANDLER));
        this.needsAttach = savedInstanceState.getBoolean(KEY_NEEDS_ATTACH);
        ArrayList childBundles = savedInstanceState.getParcelableArrayList(KEY_CHILD_ROUTERS);
        for (Bundle childBundle : childBundles) {
            ControllerHostedRouter childRouter = new ControllerHostedRouter();
            childRouter.restoreInstanceState(childBundle);
            this.monitorChildRouter(childRouter);
            this.childRouters.add(childRouter);
        }
        this.savedInstanceState = savedInstanceState.getBundle(KEY_SAVED_STATE);
        this.performOnRestoreInstanceState();
    }

    private void performOnRestoreInstanceState() {
        if (this.savedInstanceState != null && this.router != null) {
            this.onRestoreInstanceState(this.savedInstanceState);
            for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                lifecycleListener.onRestoreInstanceState(this, this.savedInstanceState);
            }
            this.savedInstanceState = null;
        }
    }

    final void changeStarted(ControllerChangeHandler changeHandler, ControllerChangeType changeType) {
        if (!changeType.isEnter) {
            for (ControllerHostedRouter router : this.childRouters) {
                router.setDetachFrozen(true);
            }
        }
        this.onChangeStarted(changeHandler, changeType);
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onChangeStart(this, changeHandler, changeType);
        }
    }

    final void changeEnded(ControllerChangeHandler changeHandler, ControllerChangeType changeType) {
        if (!changeType.isEnter) {
            for (ControllerHostedRouter router : this.childRouters) {
                router.setDetachFrozen(false);
            }
        }
        this.onChangeEnded(changeHandler, changeType);
        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
            lifecycleListener.onChangeEnd(this, changeHandler, changeType);
        }
    }

    final void setDetachFrozen(boolean frozen) {
        if (this.isDetachFrozen != frozen) {
            this.isDetachFrozen = frozen;
            for (ControllerHostedRouter router : this.childRouters) {
                router.setDetachFrozen(frozen);
            }
            if (!frozen && this.view != null && this.viewWasDetached) {
                this.detach(this.view, false);
            }
        }
    }

    final void createOptionsMenu(Menu menu, MenuInflater inflater) {
        if (this.attached && this.hasOptionsMenu && !this.optionsMenuHidden) {
            this.onCreateOptionsMenu(menu, inflater);
        }
    }

    final void prepareOptionsMenu(Menu menu) {
        if (this.attached && this.hasOptionsMenu && !this.optionsMenuHidden) {
            this.onPrepareOptionsMenu(menu);
        }
    }

    final boolean optionsItemSelected(MenuItem item) {
        return this.attached && this.hasOptionsMenu && !this.optionsMenuHidden && this.onOptionsItemSelected(item);
    }

    private void monitorChildRouter(ControllerHostedRouter childRouter) {
        childRouter.addChangeListener(this.childRouterChangeListener);
    }

    private void onChildControllerPushed(Controller controller) {
        this.childBackstack.add(controller);
        controller.addLifecycleListener(new LifecycleListener(){

            @Override
            public void postDestroy(@NonNull Controller controller) {
                Controller.this.childBackstack.remove(controller);
            }
        });
    }

    final void setParentController(Controller controller) {
        this.parentController = controller;
    }

    private void ensureRequiredConstructor() {
        Constructor[] constructors = this.getClass().getConstructors();
        if (Controller.getBundleConstructor(constructors) == null && Controller.getDefaultConstructor(constructors) == null) {
            throw new RuntimeException(this.getClass() + " does not have a constructor that takes a Bundle argument or a default constructor. Controllers must have one of these in order to restore their states.");
        }
    }

    private static Constructor getDefaultConstructor(Constructor[] constructors) {
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private static Constructor getBundleConstructor(Constructor[] constructors) {
        for (Constructor constructor : constructors) {
            if (constructor.getParameterTypes().length != 1 || constructor.getParameterTypes()[0] != Bundle.class) continue;
            return constructor;
        }
        return null;
    }

    public static abstract class LifecycleListener {
        public void onChangeStart(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull ControllerChangeType changeType) {
        }

        public void onChangeEnd(@NonNull Controller controller, @NonNull ControllerChangeHandler changeHandler, @NonNull ControllerChangeType changeType) {
        }

        public void preCreateView(@NonNull Controller controller) {
        }

        public void postCreateView(@NonNull Controller controller, @NonNull View view) {
        }

        public void preAttach(@NonNull Controller controller, @NonNull View view) {
        }

        public void postAttach(@NonNull Controller controller, @NonNull View view) {
        }

        public void preDetach(@NonNull Controller controller, @NonNull View view) {
        }

        public void postDetach(@NonNull Controller controller, @NonNull View view) {
        }

        public void preDestroyView(@NonNull Controller controller, @NonNull View view) {
        }

        public void postDestroyView(@NonNull Controller controller) {
        }

        public void preDestroy(@NonNull Controller controller) {
        }

        public void postDestroy(@NonNull Controller controller) {
        }

        public void onSaveInstanceState(@NonNull Controller controller, @NonNull Bundle outState) {
        }

        public void onRestoreInstanceState(@NonNull Controller controller, @NonNull Bundle savedInstanceState) {
        }

        public void onSaveViewState(@NonNull Controller controller, @NonNull Bundle outState) {
        }

        public void onRestoreViewState(@NonNull Controller controller, @NonNull Bundle savedViewState) {
        }
    }

    public static enum RetainViewMode {
        RELEASE_DETACH,
        RETAIN_DETACH;

    }
}

