/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerTransaction;

public class ChildControllerTransaction
extends ControllerTransaction {
    private static final String KEY_CONTAINER_ID = "ChildControllerTransaction.containerId";
    private static final String KEY_ADD_TO_LOCAL_BACKSTACK = "ChildControllerTransaction.addToLocalBackstack";
    public final int containerId;
    public final boolean addToLocalBackstack;

    ChildControllerTransaction(Builder builder) {
        super(builder);
        this.containerId = builder.containerId;
        this.addToLocalBackstack = builder.addToLocalBackstack;
    }

    ChildControllerTransaction(@NonNull Bundle bundle) {
        super(bundle);
        this.containerId = bundle.getInt(KEY_CONTAINER_ID);
        this.addToLocalBackstack = bundle.getBoolean(KEY_ADD_TO_LOCAL_BACKSTACK);
    }

    @Override
    public Bundle detachAndSaveInstanceState() {
        Bundle bundle = super.detachAndSaveInstanceState();
        bundle.putInt(KEY_CONTAINER_ID, this.containerId);
        bundle.putBoolean(KEY_ADD_TO_LOCAL_BACKSTACK, this.addToLocalBackstack);
        return bundle;
    }

    public static Builder builder(@NonNull Controller controller, @IdRes int containerId) {
        return new Builder(controller, containerId);
    }

    public static class Builder
    extends ControllerTransaction.Builder<Builder> {
        @IdRes
        final int containerId;
        boolean addToLocalBackstack;

        Builder(@NonNull Controller controller, @IdRes int containerId) {
            super(controller);
            this.containerId = containerId;
        }

        public Builder addToLocalBackstack(boolean addToLocalBackstack) {
            this.addToLocalBackstack = addToLocalBackstack;
            return this;
        }

        @Override
        public ChildControllerTransaction build() {
            return new ChildControllerTransaction(this);
        }
    }
}

