/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.ControllerChangeHandler;

public class ControllerTransaction {
    private static final String KEY_VIEW_CONTROLLER_BUNDLE = "ControllerTransaction.controller.bundle";
    private static final String KEY_PUSH_TRANSITION = "ControllerTransaction.pushControllerChangeHandler";
    private static final String KEY_POP_TRANSITION = "ControllerTransaction.popControllerChangeHandler";
    private static final String KEY_TAG = "ControllerTransaction.tag";
    public final Controller controller;
    public final String tag;
    private final ControllerChangeHandler mPushControllerChangeHandler;
    private final ControllerChangeHandler mPopControllerChangeHandler;

    ControllerTransaction(Builder builder) {
        this.controller = builder.controller;
        this.tag = builder.tag;
        this.mPushControllerChangeHandler = builder.pushControllerChangeHandler;
        this.mPopControllerChangeHandler = builder.popControllerChangeHandler;
    }

    ControllerTransaction(@NonNull Bundle bundle) {
        this.controller = Controller.newInstance(bundle.getBundle(KEY_VIEW_CONTROLLER_BUNDLE));
        this.mPushControllerChangeHandler = ControllerChangeHandler.fromBundle(bundle.getBundle(KEY_PUSH_TRANSITION));
        this.mPopControllerChangeHandler = ControllerChangeHandler.fromBundle(bundle.getBundle(KEY_POP_TRANSITION));
        this.tag = bundle.getString(KEY_TAG);
    }

    public Controller getController() {
        return this.controller;
    }

    public String getTag() {
        return this.tag;
    }

    public ControllerChangeHandler getPushControllerChangeHandler() {
        ControllerChangeHandler handler = this.controller.getOverriddenPushHandler();
        if (handler == null) {
            handler = this.mPushControllerChangeHandler;
        }
        return handler;
    }

    public ControllerChangeHandler getPopControllerChangeHandler() {
        ControllerChangeHandler handler = this.controller.getOverriddenPopHandler();
        if (handler == null) {
            handler = this.mPopControllerChangeHandler;
        }
        return handler;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putBundle(KEY_VIEW_CONTROLLER_BUNDLE, this.controller.saveInstanceState());
        if (this.mPushControllerChangeHandler != null) {
            bundle.putBundle(KEY_PUSH_TRANSITION, this.mPushControllerChangeHandler.toBundle());
        }
        if (this.mPopControllerChangeHandler != null) {
            bundle.putBundle(KEY_POP_TRANSITION, this.mPopControllerChangeHandler.toBundle());
        }
        bundle.putString(KEY_TAG, this.tag);
        return bundle;
    }

    public static class Builder<T extends Builder<T>> {
        final Controller controller;
        ControllerChangeHandler pushControllerChangeHandler;
        ControllerChangeHandler popControllerChangeHandler;
        String tag;

        public Builder(@NonNull Controller controller) {
            this.controller = controller;
        }

        public T pushChangeHandler(ControllerChangeHandler pushControllerChangeHandler) {
            this.pushControllerChangeHandler = pushControllerChangeHandler;
            return (T)this;
        }

        public T popChangeHandler(ControllerChangeHandler popControllerChangeHandler) {
            this.popControllerChangeHandler = popControllerChangeHandler;
            return (T)this;
        }

        public T tag(String tag) {
            this.tag = tag;
            return (T)this;
        }

        public ControllerTransaction build() {
            return new ControllerTransaction(this);
        }
    }

    public static enum ControllerChangeType {
        PUSH_ENTER,
        PUSH_EXIT,
        POP_ENTER,
        POP_EXIT;

    }
}

