/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.autodispose;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import com.bluelinelabs.conductor.Controller;
import com.bluelinelabs.conductor.autodispose.ControllerEvent;
import com.uber.autodispose.OutsideLifecycleException;
import io.reactivex.subjects.BehaviorSubject;

public class ControllerLifecycleSubjectHelper {
    private ControllerLifecycleSubjectHelper() {
    }

    @NonNull
    public static BehaviorSubject<ControllerEvent> create(@NonNull Controller controller) {
        if (controller.isBeingDestroyed() || controller.isDestroyed()) {
            throw new OutsideLifecycleException("Cannot bind to Controller lifecycle when outside of it.");
        }
        ControllerEvent initialState = controller.isAttached() ? ControllerEvent.ATTACH : (controller.getView() != null ? ControllerEvent.CREATE_VIEW : (controller.getActivity() != null ? ControllerEvent.CONTEXT_AVAILABLE : ControllerEvent.CREATE));
        final BehaviorSubject subject = BehaviorSubject.createDefault((Object)((Object)initialState));
        controller.addLifecycleListener(new Controller.LifecycleListener(){

            public void preContextAvailable(@NonNull Controller controller) {
                subject.onNext((Object)ControllerEvent.CONTEXT_AVAILABLE);
            }

            public void preCreateView(@NonNull Controller controller) {
                subject.onNext((Object)ControllerEvent.CREATE_VIEW);
            }

            public void preAttach(@NonNull Controller controller, @NonNull View view) {
                subject.onNext((Object)ControllerEvent.ATTACH);
            }

            public void preDetach(@NonNull Controller controller, @NonNull View view) {
                subject.onNext((Object)ControllerEvent.DETACH);
            }

            public void preDestroyView(@NonNull Controller controller, @NonNull View view) {
                subject.onNext((Object)ControllerEvent.DESTROY_VIEW);
            }

            public void preContextUnavailable(@NonNull Controller controller, @NonNull Context context) {
                subject.onNext((Object)ControllerEvent.CONTEXT_UNAVAILABLE);
            }

            public void preDestroy(@NonNull Controller controller) {
                subject.onNext((Object)ControllerEvent.DESTROY);
            }
        });
        return subject;
    }
}

