/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.conductor.archlifecycle;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import com.bluelinelabs.conductor.Controller;

public class ControllerLifecycleOwner
implements LifecycleOwner {
    private final LifecycleRegistry lifecycleRegistry;

    public <T extends Controller> ControllerLifecycleOwner(@NonNull T lifecycleController) {
        this.lifecycleRegistry = new LifecycleRegistry((LifecycleOwner)lifecycleController);
        lifecycleController.addLifecycleListener(new Controller.LifecycleListener(){

            public void postContextAvailable(@NonNull Controller controller, @NonNull Context context) {
                ControllerLifecycleOwner.this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
            }

            public void postCreateView(@NonNull Controller controller, @NonNull View view) {
                ControllerLifecycleOwner.this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
            }

            public void postAttach(@NonNull Controller controller, @NonNull View view) {
                ControllerLifecycleOwner.this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
            }

            public void preDetach(@NonNull Controller controller, @NonNull View view) {
                ControllerLifecycleOwner.this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
            }

            public void preDestroyView(@NonNull Controller controller, @NonNull View view) {
                ControllerLifecycleOwner.this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
            }

            public void preContextUnavailable(@NonNull Controller controller, @NonNull Context context) {
            }

            public void preDestroy(@NonNull Controller controller) {
                ControllerLifecycleOwner.this.lifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
            }
        });
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.lifecycleRegistry;
    }
}

