/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;

public class ParameterExpression
extends AbstractExpression {
    private String name;
    private final Object value;
    private boolean collectionValued;

    public ParameterExpression(String name) {
        this(name, null);
    }

    public ParameterExpression(String name, Object value) {
        this(name, value, false);
    }

    public ParameterExpression(String name, Object value, boolean collectionValued) {
        this.name = name;
        this.value = value;
        this.collectionValued = collectionValued;
    }

    @Override
    public ParameterExpression copy(ExpressionCopyContext copyContext) {
        return new ParameterExpression(copyContext.getNewParameterName(this.name), this.value, this.collectionValued);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isCollectionValued() {
        return this.collectionValued;
    }

    public void setCollectionValued(boolean collectionValued) {
        this.collectionValued = collectionValued;
    }

    @Override
    public String toString() {
        if (!this.collectionValued && this.value instanceof Enum) {
            Enum value = (Enum)this.value;
            return value.getDeclaringClass().getName() + "." + value.name();
        }
        if (Character.isDigit(this.name.charAt(0))) {
            return "?" + this.name;
        }
        return ":" + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterExpression)) {
            return false;
        }
        ParameterExpression that = (ParameterExpression)o;
        if (this.collectionValued != that.collectionValued) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.collectionValued ? 1 : 0);
        return result;
    }
}

