/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractNumericExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.LiteralExpression;
import com.blazebit.persistence.parser.expression.NumericType;

public class NumericLiteral
extends AbstractNumericExpression
implements LiteralExpression<String> {
    private final String value;

    public NumericLiteral(String value, NumericType numericType) {
        super(numericType);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Expression copy(ExpressionCopyContext copyContext) {
        return new NumericLiteral(this.value, this.getNumericType());
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NumericLiteral)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NumericLiteral that = (NumericLiteral)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.value;
    }
}

