/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.util;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public final class BluetoothUtils {
    private static String TAG = "BluetoothUtils";
    public static final int REQUEST_ENABLE_BT = 2001;
    private BluetoothAdapter mBluetoothAdapter = null;
    private BluetoothManager mBluetoothManager = null;
    private static BluetoothUtils mBluetoothUtils;
    private Context mContext;

    public static synchronized BluetoothUtils getInstance(Context mContext) {
        if (mBluetoothUtils == null) {
            mBluetoothUtils = new BluetoothUtils(mContext);
        }
        return mBluetoothUtils;
    }

    private BluetoothUtils(Context mContext) {
        this.mContext = mContext;
    }

    public BluetoothAdapter getBluetoothAdapter() {
        if (this.mBluetoothAdapter == null) {
            if (this.mBluetoothManager == null) {
                this.mBluetoothManager = (BluetoothManager)this.mContext.getSystemService("bluetooth");
            }
            this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
            if (this.mBluetoothAdapter == null) {
                Log.e((String)TAG, (String)"Failed to construct a BluetoothAdapter");
            }
        }
        return this.mBluetoothAdapter;
    }

    public boolean isBluetoothIsEnable() {
        if (this.getBluetoothAdapter() == null || !BluetoothUtils.isBluetoothLeSupported(this.mContext)) {
            return false;
        }
        return this.getBluetoothAdapter().isEnabled();
    }

    public void askUserToEnableBluetoothIfNeeded(Activity activity) {
        if (BluetoothUtils.isBluetoothLeSupported((Context)activity) && (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled())) {
            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            activity.startActivityForResult(enableBtIntent, 2001);
        }
    }

    public static boolean isBluetoothLeSupported(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public static void openBlueToothSetting(Activity mActivity) {
        Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
        mActivity.startActivityForResult(enableBtIntent, 2001);
    }

    public static boolean isCharacteristicRead(int property) {
        return (property & 2) > 0;
    }

    public static boolean isCharacteristicWrite(int property) {
        return (property & 4) > 0 || (property & 8) > 0;
    }

    public static boolean isCharacteristicNotify(int property) {
        return (property & 0x10) > 0 || (property & 0x20) > 0;
    }

    public static boolean isCharacteristicBroadcast(int property) {
        return (property & 1) > 0;
    }
}

