/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.blakequ.bluetooth_manager_lib.BleManager;
import com.blakequ.bluetooth_manager_lib.BleParamsOptions;
import com.blakequ.bluetooth_manager_lib.scan.BluetoothScanManager;
import com.orhanobut.logger.Logger;

@TargetApi(value=18)
public class BackgroundPowerSaver
implements Application.ActivityLifecycleCallbacks {
    private int activeActivityCount = 0;
    private Context mContext;
    public static final long DEFAULT_FOREGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 5000L;
    public static final long DEFAULT_BACKGROUND_SCAN_PERIOD = 10000L;
    public static final long DEFAULT_BACKGROUND_BETWEEN_SCAN_PERIOD = 300000L;
    private long foregroundScanPeriod = 10000L;
    private long foregroundBetweenScanPeriod = 5000L;
    private long backgroundScanPeriod = 10000L;
    private long backgroundBetweenScanPeriod = 300000L;

    public BackgroundPowerSaver(Context context, boolean countActiveActivityStrategy) {
        this(context);
    }

    public BackgroundPowerSaver(Context context) {
        if (Build.VERSION.SDK_INT < 18) {
            Logger.w((String)"BackgroundPowerSaver requires API 18 or higher.", (Object[])new Object[0]);
            return;
        }
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.mContext = context;
    }

    @Deprecated
    public void setForegroundScanPeriod(long p) {
        this.foregroundScanPeriod = p;
    }

    @Deprecated
    public void setForegroundBetweenScanPeriod(long p) {
        this.foregroundBetweenScanPeriod = p;
    }

    @Deprecated
    public void setBackgroundScanPeriod(long p) {
        this.backgroundScanPeriod = p;
    }

    @Deprecated
    public void setBackgroundBetweenScanPeriod(long p) {
        this.backgroundBetweenScanPeriod = p;
    }

    public long getScanPeriod() {
        BleParamsOptions options = BleManager.getBleParamsOptions();
        if (BluetoothScanManager.getInstance(this.mContext).isBackgroundMode()) {
            if (options != null) {
                return options.getBackgroundScanPeriod();
            }
            return this.backgroundScanPeriod;
        }
        if (options != null) {
            return options.getForegroundScanPeriod();
        }
        return this.foregroundScanPeriod;
    }

    public long getBetweenScanPeriod() {
        BleParamsOptions options = BleManager.getBleParamsOptions();
        if (BluetoothScanManager.getInstance(this.mContext).isBackgroundMode()) {
            if (options != null) {
                return options.getBackgroundBetweenScanPeriod();
            }
            return this.backgroundBetweenScanPeriod;
        }
        if (options != null) {
            return options.getForegroundBetweenScanPeriod();
        }
        return this.foregroundBetweenScanPeriod;
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        ++this.activeActivityCount;
        if (this.activeActivityCount < 1) {
            Logger.d((String)("reset active activity count on resume.  It was " + this.activeActivityCount), (Object[])new Object[0]);
            this.activeActivityCount = 1;
        }
        BluetoothScanManager.getInstance(this.mContext).setBackgroundMode(false);
        Logger.d((String)("activity resumed: " + activity + " active activities: " + this.activeActivityCount), (Object[])new Object[0]);
    }

    public void onActivityPaused(Activity activity) {
        --this.activeActivityCount;
        Logger.d((String)("activity paused: " + activity + " active activities: " + this.activeActivityCount), (Object[])new Object[0]);
        if (this.activeActivityCount < 1) {
            Logger.d((String)"setting background mode", (Object[])new Object[0]);
            BluetoothScanManager.getInstance(this.mContext).setBackgroundMode(true);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

