/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.content.ContextCompat;
import com.blakequ.bluetooth_manager_lib.scan.ScanOverListener;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.BluetoothLeScannerCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanCallbackCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanFilterCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanSettingsCompat;
import com.blakequ.bluetooth_manager_lib.util.BluetoothUtils;
import com.orhanobut.logger.Logger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@TargetApi(value=18)
public class CycledLeScanner {
    private boolean isPrintCycleTime = true;
    private final Context mContext;
    private long scanPeriod;
    private long betweenScanPeriod;
    private boolean mBackgroundFlag = false;
    private ScanCallbackCompat scanCallbackCompat;
    private final BluetoothUtils mBluetoothUtils;
    private ScanOverListener scanOverListener;
    private long nextScanStartTime = 0L;
    private long scanStopTime = 0L;
    private long lastScanEndTime = 0L;
    private boolean mScanning = false;
    private boolean isPauseScan = false;
    private boolean isOnceScan = false;
    private boolean isStartNow = false;
    private final Handler mHandler = new Handler();
    private boolean isSetScanSetting = false;
    private ScanSettingsCompat scanSettings;
    private final List<ScanFilterCompat> scanFilterCompats = new CopyOnWriteArrayList<ScanFilterCompat>();

    public CycledLeScanner(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, ScanCallbackCompat callbackCompat) {
        this.mContext = context;
        this.scanPeriod = scanPeriod;
        this.betweenScanPeriod = betweenScanPeriod;
        this.scanCallbackCompat = callbackCompat;
        this.mBackgroundFlag = backgroundFlag;
        this.mBluetoothUtils = BluetoothUtils.getInstance(context);
    }

    public void setScanOverListener(ScanOverListener scanOverListener) {
        this.scanOverListener = scanOverListener;
    }

    public void addScanFilterCompats(ScanFilterCompat scanFilter) {
        this.scanFilterCompats.add(scanFilter);
    }

    public void setScanSettings(ScanSettingsCompat scanSettings) {
        this.isSetScanSetting = true;
        this.scanSettings = scanSettings;
    }

    public void startOnceScan() {
        this.isOnceScan = true;
        this.scanLeDevice(true);
    }

    public void setPauseScan(boolean isPauseScan) {
        this.isPauseScan = isPauseScan;
        if (!isPauseScan) {
            this.scanLeDevice(true);
        } else {
            this.scanLeDevice(false);
        }
    }

    public void startScan() {
        this.isPauseScan = false;
        this.scanLeDevice(true);
    }

    public void startScanNow() {
        this.isStartNow = true;
        this.isPauseScan = false;
        this.scanLeDevice(true);
    }

    public void setBackgroundMode(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        if (Build.VERSION.SDK_INT < 18) {
            Logger.w((String)"Not supported prior to API 18.  Method invocation will be ignored", (Object[])new Object[0]);
            return;
        }
        this.scanPeriod = scanPeriod;
        this.betweenScanPeriod = betweenScanPeriod;
        if (backgroundFlag != this.mBackgroundFlag) {
            long proposedStopTime;
            long proposedNextScanStartTime;
            Logger.d((String)("restart polling task scanPeriod:" + scanPeriod + " betweenScanPeriod:" + betweenScanPeriod + " backgroundFlag:" + backgroundFlag + " mode:" + this.mBackgroundFlag), (Object[])new Object[0]);
            this.mBackgroundFlag = backgroundFlag;
            long now = SystemClock.elapsedRealtime();
            if (this.nextScanStartTime > now && (proposedNextScanStartTime = this.lastScanEndTime + betweenScanPeriod) < this.nextScanStartTime) {
                Logger.d((String)("Waiting...Adjusted nextScanStartTime to be" + (proposedNextScanStartTime - now) + " old:" + (this.nextScanStartTime - now)), (Object[])new Object[0]);
                this.nextScanStartTime = proposedNextScanStartTime;
            }
            if (this.scanStopTime > now && (proposedStopTime = this.nextScanStartTime + scanPeriod) < this.scanStopTime) {
                Logger.d((String)("Scanning...Adjusted scanStopTime to be " + (proposedStopTime - now) + " old:" + (this.scanStopTime - now)), (Object[])new Object[0]);
                this.scanStopTime = proposedStopTime;
            }
            if (!this.isSetScanSetting || this.scanSettings == null) {
                if (this.mBackgroundFlag) {
                    Logger.d((String)"starting filtered scan in SCAN_MODE_LOW_POWER", (Object[])new Object[0]);
                    this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(0).build();
                } else {
                    Logger.d((String)"starting non-filtered scan in SCAN_MODE_LOW_LATENCY", (Object[])new Object[0]);
                    this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(2).build();
                }
            }
        }
    }

    public boolean isScanning() {
        return this.mScanning;
    }

    public boolean isPauseScan() {
        return this.isPauseScan;
    }

    private void scanLeDevice(boolean enable) {
        BluetoothAdapter mAdapter = this.mBluetoothUtils.getBluetoothAdapter();
        if (this.mBluetoothUtils == null || !this.mBluetoothUtils.isBluetoothIsEnable()) {
            Logger.e((String)"ScanDevice: Scanning fail! BluetoothAdapter is null", (Object[])new Object[0]);
            return;
        }
        if (enable) {
            if (this.deferScanIfNeeded()) {
                if (!this.isStartNow) {
                    return;
                }
                Logger.i((String)"ScanDevice: Scan right now!", (Object[])new Object[0]);
                this.isStartNow = false;
            }
            if (this.mScanning) {
                Logger.d((String)"ScanDevice: Scanning is running now !", (Object[])new Object[0]);
                return;
            }
            Logger.d((String)("ScanDevice: Starting Scanning scanPeriod:" + this.scanPeriod + ", between:" + this.betweenScanPeriod), (Object[])new Object[0]);
            this.mScanning = true;
            if (!this.isPauseScan || this.isOnceScan) {
                try {
                    if (Build.VERSION.SDK_INT < 23 || this.checkLocationPermission()) {
                        if (Build.VERSION.SDK_INT >= 23 && !CycledLeScanner.isGpsProviderEnabled(this.mContext)) {
                            Logger.e((String)("If SDK>=23, current SDK=" + Build.VERSION.SDK_INT + ", Location info not open and can not scan any device!"), (Object[])new Object[0]);
                            this.scanCallbackCompat.onScanFailed(6);
                        } else {
                            Logger.i((String)"ScanDevice: Start scan...", (Object[])new Object[0]);
                            BluetoothLeScannerCompat.startScan(mAdapter, this.scanFilterCompats, this.getScanSettings(), this.scanCallbackCompat);
                        }
                    } else {
                        this.scanCallbackCompat.onScanFailed(5);
                        Logger.e((String)("If SDK>=23, current SDK=" + Build.VERSION.SDK_INT + ", Please check the location permission is enabled(ACCESS_COARSE_LOCATION and ACCESS_FINE_LOCATION)"), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Logger.e((String)("Internal Android exception scanning for beacons " + e.toString()), (Object[])new Object[0]);
                }
                if (this.isOnceScan) {
                    Logger.d((String)"ScanDevice: Scanning once", (Object[])new Object[0]);
                    this.isOnceScan = false;
                }
            } else {
                Logger.d((String)"ScanDevice: Pause Scanning", (Object[])new Object[0]);
            }
            this.scanStopTime = SystemClock.elapsedRealtime() + this.scanPeriod;
            this.nextScanStartTime = this.scanStopTime + this.betweenScanPeriod;
            this.scheduleScanStop();
        } else {
            Logger.d((String)"ScanDevice: Stopping Scan", (Object[])new Object[0]);
            this.stopScan();
        }
    }

    private void scheduleScanStop() {
        long millisecondsUntilStop = this.scanStopTime - SystemClock.elapsedRealtime();
        if (millisecondsUntilStop > 0L) {
            if (this.isPrintCycleTime) {
                Logger.d((String)("Waiting to stop scan cycle for another " + millisecondsUntilStop + " milliseconds"), (Object[])new Object[0]);
            }
            if (!this.isPauseScan) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CycledLeScanner.this.scheduleScanStop();
                    }
                }, millisecondsUntilStop > 1000L ? 1000L : millisecondsUntilStop);
            }
        } else {
            Logger.d((String)"Stop cycle scan", (Object[])new Object[0]);
            this.stopScan();
        }
    }

    private void stopScan() {
        if (this.mScanning) {
            BluetoothAdapter mAdapter = this.mBluetoothUtils.getBluetoothAdapter();
            if (mAdapter != null && this.mBluetoothUtils.isBluetoothIsEnable()) {
                try {
                    BluetoothLeScannerCompat.stopScan(mAdapter, this.scanCallbackCompat);
                    this.lastScanEndTime = SystemClock.elapsedRealtime();
                    Logger.d((String)("stopping bluetooth le scan " + this.lastScanEndTime), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    Logger.w((String)("Internal Android exception scanning for beacons " + e.toString()), (Object[])new Object[0]);
                }
            } else {
                Logger.d((String)"Bluetooth is disabled.  Cannot scan for beacons.", (Object[])new Object[0]);
            }
            this.nextScanStartTime = SystemClock.elapsedRealtime() + this.betweenScanPeriod;
            if (!this.isPauseScan) {
                this.scanLeDevice(true);
            }
        }
        this.mScanning = false;
        if (this.scanOverListener != null) {
            this.scanOverListener.onScanOver();
        }
    }

    private boolean deferScanIfNeeded() {
        long millisecondsUntilStart = this.nextScanStartTime - SystemClock.elapsedRealtime();
        if (millisecondsUntilStart > 0L) {
            if (this.isPrintCycleTime) {
                Logger.d((String)("Waiting to start next Bluetooth scan for another " + millisecondsUntilStart + " milliseconds"), (Object[])new Object[0]);
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!CycledLeScanner.this.isPauseScan) {
                        CycledLeScanner.this.scanLeDevice(true);
                    }
                }
            }, millisecondsUntilStart > 1000L ? 1000L : millisecondsUntilStart);
            return true;
        }
        Logger.d((String)"Start cycle scan", (Object[])new Object[0]);
        return false;
    }

    private ScanSettingsCompat getScanSettings() {
        if (this.scanSettings == null) {
            if (this.mBackgroundFlag) {
                Logger.d((String)"starting filtered scan in SCAN_MODE_LOW_POWER", (Object[])new Object[0]);
                this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(0).build();
            } else {
                Logger.d((String)"starting non-filtered scan in SCAN_MODE_LOW_LATENCY", (Object[])new Object[0]);
                this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(2).build();
            }
        }
        return this.scanSettings;
    }

    public static boolean isGpsProviderEnabled(Context context) {
        LocationManager service = (LocationManager)context.getSystemService("location");
        return service.isProviderEnabled("gps");
    }

    private boolean checkLocationPermission() {
        return this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") || this.checkPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    private boolean checkPermission(String permission2) {
        return ContextCompat.checkSelfPermission((Context)this.mContext, (String)permission2) == 0;
    }
}

