/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device.ibeacon;

import com.blakequ.bluetooth_manager_lib.device.BeaconManufacturerData;
import com.blakequ.bluetooth_manager_lib.device.BeaconType;
import com.blakequ.bluetooth_manager_lib.device.BluetoothLeDevice;
import com.blakequ.bluetooth_manager_lib.device.ibeacon.IBeaconUtils;
import com.blakequ.bluetooth_manager_lib.util.ByteUtils;
import java.util.Arrays;

public final class IBeaconManufacturerData
extends BeaconManufacturerData {
    private final int mCalibratedTxPower;
    private final int mCompanyIdentidier;
    private final int mIBeaconAdvertisment;
    private final int mMajor;
    private final int mMinor;
    private final String mUUID;

    public IBeaconManufacturerData(BluetoothLeDevice device) {
        this(device.getAdRecordStore().getRecord(255).getData());
    }

    public IBeaconManufacturerData(byte[] manufacturerData) {
        super(BeaconType.IBEACON, manufacturerData);
        byte[] intArray = Arrays.copyOfRange(manufacturerData, 0, 2);
        ByteUtils.invertArray(intArray);
        this.mCompanyIdentidier = ByteUtils.getIntFrom2ByteArray(intArray);
        this.mIBeaconAdvertisment = ByteUtils.getIntFrom2ByteArray(Arrays.copyOfRange(manufacturerData, 2, 4));
        this.mUUID = IBeaconUtils.calculateUuidString(Arrays.copyOfRange(manufacturerData, 4, 20));
        this.mMajor = ByteUtils.getIntFrom2ByteArray(Arrays.copyOfRange(manufacturerData, 20, 22));
        this.mMinor = ByteUtils.getIntFrom2ByteArray(Arrays.copyOfRange(manufacturerData, 22, 24));
        this.mCalibratedTxPower = manufacturerData[24];
    }

    public int getCalibratedTxPower() {
        return this.mCalibratedTxPower;
    }

    public int getCompanyIdentifier() {
        return this.mCompanyIdentidier;
    }

    public int getIBeaconAdvertisement() {
        return this.mIBeaconAdvertisment;
    }

    public int getMajor() {
        return this.mMajor;
    }

    public int getMinor() {
        return this.mMinor;
    }

    public String getUUID() {
        return this.mUUID;
    }
}

