/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device.adrecord;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

public final class AdRecord
implements Parcelable {
    public static final int TYPE_FLAGS = 1;
    public static final int TYPE_UUID16_INC = 2;
    public static final int TYPE_UUID16 = 3;
    public static final int TYPE_UUID32_INC = 4;
    public static final int TYPE_UUID32 = 5;
    public static final int TYPE_UUID128_INC = 6;
    public static final int TYPE_UUID128 = 7;
    public static final int TYPE_LOCAL_NAME_SHORT = 8;
    public static final int TYPE_LOCAL_NAME_COMPLETE = 9;
    public static final int TYPE_TX_POWER_LEVEL = 10;
    public static final int TYPE_DEVICE_CLASS = 13;
    public static final int TYPE_SIMPLE_PAIRING_HASH_C = 14;
    public static final int TYPE_SIMPLE_PAIRING_RANDOMIZER_R = 15;
    public static final int TYPE_TK_VALUE = 16;
    public static final int TYPE_SECURITY_MANAGER_OOB_FLAGS = 17;
    public static final int TYPE_CONNECTION_INTERVAL_RANGE = 18;
    public static final int TYPE_SERVICE_UUIDS_LIST_16BIT = 20;
    public static final int TYPE_SERVICE_UUIDS_LIST_128BIT = 21;
    public static final int TYPE_SERVICE_DATA = 22;
    public static final int TYPE_MANUFACTURER_SPECIFIC_DATA = 255;
    public static final Parcelable.Creator<AdRecord> CREATOR = new Parcelable.Creator<AdRecord>(){

        public AdRecord createFromParcel(Parcel in) {
            return new AdRecord(in);
        }

        public AdRecord[] newArray(int size) {
            return new AdRecord[size];
        }
    };
    private static final String PARCEL_RECORD_DATA = "record_data";
    private static final String PARCEL_RECORD_TYPE = "record_type";
    private static final String PARCEL_RECORD_LENGTH = "record_length";
    private final int mLength;
    private final int mType;
    private final byte[] mData;

    public AdRecord(int length, int type, byte[] data) {
        this.mLength = length;
        this.mType = type;
        this.mData = data;
    }

    public AdRecord(Parcel in) {
        Bundle b = in.readBundle(this.getClass().getClassLoader());
        this.mLength = b.getInt(PARCEL_RECORD_LENGTH);
        this.mType = b.getInt(PARCEL_RECORD_TYPE);
        this.mData = b.getByteArray(PARCEL_RECORD_DATA);
    }

    public int describeContents() {
        return 0;
    }

    public byte[] getData() {
        return this.mData;
    }

    public String getHumanReadableType() {
        return AdRecord.getHumanReadableAdType(this.mType);
    }

    public int getLength() {
        return this.mLength;
    }

    public int getType() {
        return this.mType;
    }

    public String toString() {
        return "AdRecord [mLength=" + this.mLength + ", mType=" + this.mType + ", mData=" + Arrays.toString(this.mData) + ", getHumanReadableType()=" + this.getHumanReadableType() + "]";
    }

    public void writeToParcel(Parcel parcel, int arg1) {
        Bundle b = new Bundle(this.getClass().getClassLoader());
        b.putInt(PARCEL_RECORD_LENGTH, this.mLength);
        b.putInt(PARCEL_RECORD_TYPE, this.mType);
        b.putByteArray(PARCEL_RECORD_DATA, this.mData);
        parcel.writeBundle(b);
    }

    private static String getHumanReadableAdType(int type) {
        switch (type) {
            case 18: {
                return "Slave Connection Interval Range";
            }
            case 13: {
                return "Class of device";
            }
            case 1: {
                return "Flags";
            }
            case 255: {
                return "Manufacturer Specific Data";
            }
            case 9: {
                return "Name (Complete)";
            }
            case 8: {
                return "Name (Short)";
            }
            case 17: {
                return "Security Manager OOB Flags";
            }
            case 21: {
                return "Service UUIDs (128bit)";
            }
            case 20: {
                return "Service UUIDs (16bit)";
            }
            case 22: {
                return "Service Data";
            }
            case 14: {
                return "Simple Pairing Hash C";
            }
            case 15: {
                return "Simple Pairing Randomizer R";
            }
            case 16: {
                return "TK Value";
            }
            case 10: {
                return "Transmission Power Level";
            }
            case 7: {
                return "Complete list of 128-bit UUIDs available";
            }
            case 6: {
                return "More 128-bit UUIDs available";
            }
            case 3: {
                return "Complete list of 16-bit UUIDs available";
            }
            case 2: {
                return "More 16-bit UUIDs available";
            }
            case 5: {
                return "Complete list of 32-bit UUIDs available";
            }
            case 4: {
                return "More 32-bit UUIDs available";
            }
        }
        return "Unknown AdRecord Structure: " + type;
    }
}

