/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.util;

import android.util.SparseArray;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class ByteUtils {
    private static final String HEXES = "0123456789ABCDEF";

    private ByteUtils() {
    }

    public static String byteArrayToHexString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        sb.append('[');
        for (byte b : array) {
            if (!firstEntry) {
                sb.append(", ");
            }
            sb.append(HEXES.charAt((b & 0xF0) >> 4));
            sb.append(HEXES.charAt(b & 0xF));
            firstEntry = false;
        }
        sb.append(']');
        return sb.toString();
    }

    public static boolean doesArrayBeginWith(byte[] array, byte[] prefix) {
        if (array.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static int getIntFrom2ByteArray(byte[] input) {
        byte[] result = new byte[]{0, 0, input[0], input[1]};
        return ByteUtils.getIntFromByteArray(result);
    }

    public static int getIntFromByte(byte bite) {
        return bite & 0xFF;
    }

    public static int getIntFromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    public static long getLongFromByteArray(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getLong();
    }

    public static void invertArray(byte[] array) {
        int size = array.length;
        for (int i = 0; i < size / 2; ++i) {
            byte temp = array[i];
            array[i] = array[size - 1 - i];
            array[size - 1 - i] = temp;
        }
    }

    public static String toString(SparseArray<byte[]> array) {
        if (array == null) {
            return "null";
        }
        if (array.size() == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        for (int i = 0; i < array.size(); ++i) {
            buffer.append(array.keyAt(i)).append("=").append(array.valueAt(i));
        }
        buffer.append('}');
        return buffer.toString();
    }

    public static <T> String toString(Map<T, byte[]> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('{');
        Iterator<Map.Entry<T, byte[]>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, byte[]> entry = it.next();
            T key = entry.getKey();
            buffer.append(key).append("=").append(Arrays.toString(map.get(key)));
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }
}

