/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect;

import android.os.SystemClock;
import com.blakequ.bluetooth_manager_lib.connect.ConnectConfig;

public class ReconnectParamsBean {
    private String address;
    private int number;
    private long nextReconnectTime;
    private long startDisconnectTime;
    private static long BASE_SPACE_TIME = ConnectConfig.reconnectTime;

    public ReconnectParamsBean(String address) {
        this.address = address;
        this.startDisconnectTime = SystemClock.elapsedRealtime();
        this.number = 1;
    }

    public String getAddress() {
        return this.address;
    }

    public void updateAddress(String address) {
        this.address = address;
        this.startDisconnectTime = SystemClock.elapsedRealtime();
        this.number = 1;
    }

    public long getNextReconnectTime() {
        this.nextReconnectTime = this.number <= ConnectConfig.reconnectedNum ? this.startDisconnectTime + BASE_SPACE_TIME * (long)this.number : (long)((double)this.startDisconnectTime + (double)BASE_SPACE_TIME * Math.pow(2.0, this.number));
        return this.nextReconnectTime;
    }

    public int getNumber() {
        return this.number;
    }

    public void addNumber() {
        this.startDisconnectTime = SystemClock.elapsedRealtime();
        ++this.number;
    }

    public void setNumber(int num) {
        this.number = num;
    }

    public String toString() {
        return "ReconnectParamsBean{address='" + this.address + '\'' + ", number=" + this.number + ", next reconnect after " + (this.getNextReconnectTime() - this.startDisconnectTime) / 1000L + "seconds" + ", startDisconnectTime=" + this.startDisconnectTime + '}';
    }
}

