/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothOperatorQueue;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothSubScribeData;
import com.blakequ.bluetooth_manager_lib.connect.GattError;
import com.blakequ.bluetooth_manager_lib.util.BluetoothUtils;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.UUID;

public abstract class BluetoothConnectInterface {
    protected static final String TAG = "BluetoothConnectInterface";
    protected Context context;
    private BluetoothOperatorQueue mOpratorQueue;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    protected BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onCharacteristicChanged(gatt, characteristic);
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            LogUtils.i(BluetoothConnectInterface.TAG, "onCharacteristicRead data status:" + GattError.parseConnectionError(status) + " " + characteristic.getUuid().toString());
            BluetoothConnectInterface.this.mOpratorQueue.nextOperator();
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onCharacteristicRead(gatt, characteristic, status);
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            LogUtils.i(BluetoothConnectInterface.TAG, "onCharacteristicWrite write status:" + GattError.parseConnectionError(status));
            BluetoothConnectInterface.this.mOpratorQueue.nextOperator();
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onCharacteristicWrite(gatt, characteristic, status);
            }
        }

        public void onConnectionStateChange(final BluetoothGatt gatt, int status, final int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            LogUtils.i(BluetoothConnectInterface.TAG, "onConnectionStateChange gattStatus=" + GattError.parseConnectionError(status) + " newStatus=" + (newState == 2 ? "CONNECTED" : "DISCONNECTED"));
            if (status == 0) {
                if (newState == 2) {
                    LogUtils.i(BluetoothConnectInterface.TAG, "Connected to GATT server");
                    BluetoothConnectInterface.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothConnectInterface.this.onDeviceConnected(gatt);
                            if (gatt != null && !gatt.discoverServices()) {
                                LogUtils.e(BluetoothConnectInterface.TAG, "onConnectionStateChange start service discovery fail! Thread:" + Thread.currentThread());
                            }
                        }
                    });
                } else if (newState == 0) {
                    BluetoothConnectInterface.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothConnectInterface.this.onDeviceDisconnect(gatt, newState);
                        }
                    });
                }
            } else {
                BluetoothConnectInterface.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothConnectInterface.this.onDeviceDisconnect(gatt, newState);
                    }
                });
            }
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onConnectionStateChange(gatt, status, newState);
            }
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorRead(gatt, descriptor, status);
            LogUtils.i(BluetoothConnectInterface.TAG, "onDescriptorRead status=" + GattError.parseConnectionError(status));
            BluetoothConnectInterface.this.mOpratorQueue.nextOperator();
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onDescriptorRead(gatt, descriptor, status);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorWrite(gatt, descriptor, status);
            LogUtils.i(BluetoothConnectInterface.TAG, "onDescriptorWrite status=" + GattError.parseConnectionError(status));
            BluetoothConnectInterface.this.mOpratorQueue.nextOperator();
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onDescriptorWrite(gatt, descriptor, status);
            }
        }

        @TargetApi(value=21)
        public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
            super.onMtuChanged(gatt, mtu, status);
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onMtuChanged(gatt, mtu, status);
            }
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            super.onReadRemoteRssi(gatt, rssi, status);
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onReadRemoteRssi(gatt, rssi, status);
            }
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            super.onReliableWriteCompleted(gatt, status);
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onReliableWriteCompleted(gatt, status);
            }
        }

        public void onServicesDiscovered(final BluetoothGatt gatt, int status) {
            LogUtils.i(BluetoothConnectInterface.TAG, "onServicesDiscovered status=" + GattError.parseConnectionError(status));
            if (status == 0) {
                BluetoothConnectInterface.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothConnectInterface.this.onDiscoverServicesSuccess(gatt);
                        if (gatt != null) {
                            BluetoothConnectInterface.this.startSubscribe(gatt);
                        }
                    }
                });
            } else {
                LogUtils.e(BluetoothConnectInterface.TAG, "onServicesDiscovered fail!");
                BluetoothConnectInterface.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothConnectInterface.this.onDiscoverServicesFail(gatt);
                    }
                });
            }
            if (BluetoothConnectInterface.this.getBluetoothGattCallback() != null) {
                BluetoothConnectInterface.this.getBluetoothGattCallback().onServicesDiscovered(gatt, status);
            }
        }
    };

    public BluetoothConnectInterface(Context context) {
        this.context = context;
        this.mOpratorQueue = new BluetoothOperatorQueue();
    }

    public abstract void release();

    protected abstract BluetoothGattCallback getBluetoothGattCallback();

    protected abstract String getServiceUUID();

    public abstract BluetoothGatt getBluetoothGatt(String var1);

    protected abstract List<BluetoothSubScribeData> getSubscribeDataList();

    protected abstract void onDeviceDisconnect(BluetoothGatt var1, int var2);

    protected abstract void onDeviceConnected(BluetoothGatt var1);

    protected abstract void onDiscoverServicesFail(BluetoothGatt var1);

    protected abstract void onDiscoverServicesSuccess(BluetoothGatt var1);

    public final void runOnUiThread(Runnable action) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            this.mHandler.post(action);
        } else {
            action.run();
        }
    }

    protected Handler getMainLooperHandler() {
        return this.mHandler;
    }

    public void startSubscribe(BluetoothGatt bluetoothGatt) {
        if (bluetoothGatt == null) {
            LogUtils.e(TAG, "Fail to subscribe, BluetoothGatt is null");
            return;
        }
        this.subscribe(bluetoothGatt.getDevice().getAddress());
        this.mOpratorQueue.start(bluetoothGatt);
    }

    protected void subscribe(String address) {
        BluetoothGatt mBluetoothGatt = this.getBluetoothGatt(address);
        if (mBluetoothGatt == null) {
            LogUtils.e(TAG, "can not subscribe to ble device info " + address);
            return;
        }
        this.mOpratorQueue.clean();
        if (this.isEmpty(this.getServiceUUID())) {
            LogUtils.e(TAG, "Service UUID is null");
            return;
        }
        if (this.isEmpty(this.getSubscribeDataList())) {
            LogUtils.e(TAG, "Subscribe BLE data is null, you must invoke addBluetoothSubscribeData to add data");
            return;
        }
        BluetoothGattService gattService = mBluetoothGatt.getService(UUID.fromString(this.getServiceUUID()));
        if (gattService != null) {
            for (BluetoothSubScribeData data : this.getSubscribeDataList()) {
                BluetoothGattCharacteristic characteristic = gattService.getCharacteristic(data.getCharacteristicUUID());
                if (characteristic != null) {
                    switch (data.getOperatorType()) {
                        case CHAR_WIRTE: {
                            if (BluetoothUtils.isCharacteristicWrite(characteristic.getProperties())) {
                                characteristic.setValue(data.getCharacteristicValue());
                                this.mOpratorQueue.addOperator(characteristic, true);
                                break;
                            }
                            LogUtils.e(TAG, "Fail to write characteristic, not have write property , uuid:" + characteristic.getUuid() + " ,property:" + characteristic.getProperties());
                            break;
                        }
                        case CHAR_READ: {
                            if (this.checkIsSamsung()) {
                                this.setProperty(characteristic);
                            }
                            if (BluetoothUtils.isCharacteristicRead(characteristic.getProperties())) {
                                this.mOpratorQueue.addOperator(characteristic, false);
                                break;
                            }
                            LogUtils.e(TAG, "Fail to read characteristic, not have read property , uuid:" + characteristic.getUuid() + " ,property:" + characteristic.getProperties());
                            break;
                        }
                        case DESC_READ: {
                            BluetoothGattDescriptor descriptor = characteristic.getDescriptor(data.getDescriptorUUID());
                            if (descriptor != null) {
                                this.mOpratorQueue.addOperator(descriptor, false);
                                break;
                            }
                            LogUtils.e(TAG, "Fail to get descriptor read uuid:" + data.getDescriptorUUID());
                            break;
                        }
                        case DESC_WRITE: {
                            BluetoothGattDescriptor descriptor2 = characteristic.getDescriptor(data.getDescriptorUUID());
                            if (descriptor2 != null) {
                                descriptor2.setValue(data.getDescriptorValue());
                                this.mOpratorQueue.addOperator(descriptor2, true);
                                break;
                            }
                            LogUtils.e(TAG, "Fail to get descriptor write uuid:" + data.getDescriptorUUID());
                            break;
                        }
                        case NOTIFY: {
                            if (BluetoothUtils.isCharacteristicNotify(characteristic.getProperties())) {
                                mBluetoothGatt.setCharacteristicNotification(characteristic, true);
                                BluetoothGattDescriptor descriptor3 = characteristic.getDescriptor(data.getDescriptorUUID());
                                if (descriptor3 != null) {
                                    descriptor3.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                                    this.mOpratorQueue.addOperator(descriptor3, true);
                                    break;
                                }
                                LogUtils.e(TAG, "Fail to get notify descriptor uuid:" + data.getDescriptorUUID());
                                break;
                            }
                            LogUtils.e(TAG, "Fail to notify characteristic, not have notify property , uuid:" + characteristic.getUuid() + " ,property:" + characteristic.getProperties());
                        }
                    }
                    continue;
                }
                LogUtils.e(TAG, "Fail to get characteristic service uuid:" + data.getCharacteristicUUID());
            }
        } else {
            LogUtils.e(TAG, "Can not get gatt service uuid:" + this.getServiceUUID());
        }
    }

    private void setProperty(BluetoothGattCharacteristic flagReadChar) {
        Field properField = null;
        try {
            properField = flagReadChar.getClass().getDeclaredField("mProperties");
            properField.setAccessible(true);
            properField.set(flagReadChar, 10);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected boolean checkIsSamsung() {
        String brand = Build.BRAND;
        return brand.toLowerCase().equals("samsung");
    }

    public boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public <V> boolean isEmpty(List<V> sourceList) {
        return sourceList == null || sourceList.size() == 0;
    }
}

