/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.bitly.Bitly;
import com.bitly.Error;
import com.bitly.HttpAsyncTask;
import com.bitly.Response;

class Shortener {
    Shortener() {
    }

    private static String shortenUrl() {
        return Bitly.baseUrl().replace("bit.ly", "api-ssl.bitly.com") + "v4/shorten";
    }

    static void shorten(final String link, final Bitly.Callback callback) {
        if (TextUtils.isEmpty((CharSequence)link)) {
            if (callback != null) {
                callback.onError(new Error("Valid link required to shorten", null, null, null));
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)Bitly.currentAccessToken())) {
            if (callback != null) {
                callback.onError(new Error("Access token required to shorten", null, null, null));
            }
            return;
        }
        Uri.Builder builder = Uri.parse((String)Shortener.shortenUrl()).buildUpon();
        String json = String.format("{\"long_url\":\"%s\"}", link);
        new HttpAsyncTask(builder.build(), Bitly.currentAccessToken(), json){

            @Override
            void onResponse(Response response) {
                Log.d((String)"BitlySDK", (String)"Bitly SDK parsing JSON shorten response and calling callback");
                if (callback != null) {
                    callback.onResponse(response);
                }
            }

            @Override
            void onException(Exception e) {
                Log.d((String)"BitlySDK", (String)("Bitly SDK failed to parse shorten JSON: " + e.getMessage()));
                if (callback != null) {
                    callback.onError(new Error(e.getMessage(), e, link, null));
                }
            }
        }.executeSafely();
    }
}

