/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.bitly.Response;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

abstract class HttpAsyncTask
extends AsyncTask<Void, Void, Void> {
    private final Uri uri;
    private final String accessToken;
    private final String body;
    private boolean exceptionOccurred = false;

    public HttpAsyncTask(Uri uri) {
        this.uri = uri;
        this.accessToken = null;
        this.body = null;
    }

    public HttpAsyncTask(Uri uri, String accessToken, String body) {
        this.uri = uri;
        this.accessToken = accessToken;
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Void doInBackground(Void ... params) {
        HttpURLConnection connection = null;
        BufferedReader reader = null;
        OutputStream outputStream = null;
        try {
            String line;
            connection = (HttpURLConnection)new URL(this.uri.toString()).openConnection();
            if (this.accessToken != null) {
                connection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
                connection.setRequestProperty("Content-Type", "application/json");
            }
            if (this.body != null) {
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                outputStream = connection.getOutputStream();
                byte[] input = this.body.getBytes("utf-8");
                outputStream.write(input, 0, input.length);
            }
            reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(connection.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            Response response = new Response(new JSONObject(result.toString()));
            if (response.getStatusCode() != 200) {
                this.exceptionOccurred = true;
            }
            this.onResponse(response);
        }
        catch (Exception e) {
            this.exceptionOccurred = true;
            this.onException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)"BitlySDK", (String)"Bitly SDK failed to close reader", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)"BitlySDK", (String)"Bitly SDK failed to close writer", (Throwable)e);
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    public final void executeSafely() {
        if (Build.VERSION.SDK_INT >= 11 && AsyncTask.THREAD_POOL_EXECUTOR != null) {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            this.execute(new Void[0]);
        }
    }

    public boolean exceptionOccurred() {
        return this.exceptionOccurred;
    }

    abstract void onResponse(Response var1);

    abstract void onException(Exception var1);
}

