/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.bitly.Correlator;
import com.bitly.Decoder;
import com.bitly.Error;
import com.bitly.Response;
import com.bitly.Shortener;
import java.util.ArrayList;
import java.util.List;

public final class Bitly {
    private static final String DEFAULT_BASE_URL = "https://bit.ly/";
    private static Bitly sharedInstance = new Bitly();
    private String appId;
    private String accessToken;
    private String deviceId;
    private List<String> supportedDomains = new ArrayList<String>();
    private List<String> supportedSchemes = new ArrayList<String>();
    private boolean instantApp;
    private Callback callback;
    private Correlator correlator;
    private static String baseUrl = null;

    public static void initialize(@NonNull Context context, @NonNull String appId, @NonNull String accessToken, @NonNull List<String> supportedDomains, @NonNull List<String> supportedSchemes, Callback callback) {
        Bitly.initialize(context, appId, accessToken, supportedDomains, supportedSchemes, false, callback);
    }

    public static void initialize(@NonNull Context context, @NonNull String appId, @NonNull String accessToken, @NonNull List<String> supportedDomains, @NonNull List<String> supportedSchemes, boolean instantApp, Callback callback) {
        Bitly.initialize(context, appId, supportedDomains, supportedSchemes, instantApp, callback);
        Bitly.initialize(context, accessToken);
    }

    public static void initialize(@NonNull Context context, @NonNull String appId, @NonNull List<String> supportedDomains, @NonNull List<String> supportedSchemes, Callback callback) {
        Bitly.initialize(context, appId, supportedDomains, supportedSchemes, false, callback);
    }

    public static void initialize(final @NonNull Context context, @NonNull String appId, @NonNull List<String> supportedDomains, @NonNull List<String> supportedSchemes, boolean instantApp, Callback callback) {
        Bitly.setBaseUrl(context);
        Bitly.sharedInstance.appId = appId;
        Bitly.sharedInstance.deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Bitly.sharedInstance.supportedDomains.addAll(supportedDomains);
        Bitly.sharedInstance.supportedSchemes.addAll(supportedSchemes);
        Bitly.sharedInstance.instantApp = instantApp;
        Bitly.sharedInstance.callback = callback;
        Bitly.sharedInstance.correlator = new Correlator(context);
        Bitly.sharedInstance.correlator.correlate(Bitly.sharedInstance.appId, Bitly.sharedInstance.deviceId, new Correlator.Callback(){

            @Override
            public void onCorrelate(boolean correlated) {
                Decoder.handleDeeplink(context, correlated);
            }
        });
        Log.d((String)"BitlySDK", (String)String.format("Bitly SDK initialized with App ID: %s and Device ID: %s", Bitly.sharedInstance.appId, Bitly.sharedInstance.deviceId));
    }

    public static void initialize(@NonNull Context context, @NonNull String accessToken) {
        Bitly.setBaseUrl(context);
        Bitly.sharedInstance.accessToken = accessToken;
        Log.d((String)"BitlySDK", (String)String.format("Bitly SDK initialized with Auth Token: %s", Bitly.sharedInstance.accessToken));
    }

    public static void reset() {
        Bitly.sharedInstance.appId = null;
        Bitly.sharedInstance.accessToken = null;
        Bitly.sharedInstance.deviceId = null;
        Bitly.sharedInstance.supportedDomains.clear();
        Bitly.sharedInstance.supportedSchemes.clear();
        Bitly.sharedInstance.instantApp = false;
        Bitly.sharedInstance.callback = null;
        if (Bitly.sharedInstance.correlator != null) {
            Bitly.sharedInstance.correlator.reset();
        }
        Bitly.sharedInstance.correlator = null;
        Log.d((String)"BitlySDK", (String)"Bitly SDK reset");
    }

    public static void handleIntent(Intent intent) {
        Decoder.handle(intent);
    }

    public static void retryError(Error error) {
        Decoder.handle(error);
    }

    public static void shorten(String link, Callback callback) {
        Shortener.shorten(link, callback);
    }

    static String currentAppId() {
        return Bitly.sharedInstance.appId;
    }

    static String currentAccessToken() {
        return Bitly.sharedInstance.accessToken;
    }

    static String currentDeviceId() {
        return Bitly.sharedInstance.deviceId;
    }

    static Callback currentCallback() {
        return Bitly.sharedInstance.callback;
    }

    static boolean isInstantApp() {
        return Bitly.sharedInstance.instantApp;
    }

    static boolean domainSupported(@NonNull String url) {
        return Bitly.sharedInstance.supportedDomains.contains(Uri.parse((String)url).getHost());
    }

    static boolean schemeSupported(@NonNull String url) {
        Uri uri = Uri.parse((String)url);
        for (String scheme : Bitly.sharedInstance.supportedSchemes) {
            if (!uri.getScheme().equals(scheme) && (!scheme.contains("://") || !uri.toString().startsWith(scheme))) continue;
            return true;
        }
        return false;
    }

    private static void setBaseUrl(Context context) {
        String customBaseUrl = PreferenceManager.getDefaultSharedPreferences((Context)context).getString("com.bitly.custom.base.url", null);
        if (!TextUtils.isEmpty((CharSequence)customBaseUrl)) {
            baseUrl = customBaseUrl;
        }
    }

    protected static String baseUrl() {
        if (TextUtils.isEmpty((CharSequence)baseUrl)) {
            baseUrl = DEFAULT_BASE_URL;
        }
        return baseUrl;
    }

    public static interface Callback {
        public void onResponse(Response var1);

        public void onError(Error var1);
    }
}

