/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.bitly.Bitly;
import com.bitly.WebHelper;
import java.lang.reflect.Method;

final class Correlator
implements WebHelper.Callback {
    private Context context;
    private Callback callback;
    private SharedPreferences sharedPreferences;

    Correlator(Context context) {
        this.context = context;
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    final synchronized void correlate(String appId, String deviceId, Callback callback) {
        this.callback = callback;
        if (System.currentTimeMillis() - this.sharedPreferences.getLong("bitly.last.correlation", 0L) > 1209600000L) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK correlator initializing");
            WebHelper.loadUri(this.context, this.constructUrl(appId, deviceId), this);
            this.sharedPreferences.edit().putLong("bitly.last.correlation", System.currentTimeMillis()).apply();
        } else {
            Log.d((String)"BitlySDK", (String)"Bitly SDK correlator not run");
            if (callback != null) {
                callback.onCorrelate(false);
            }
        }
    }

    final Uri constructUrl(String appId, String deviceId) {
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int width = 0;
        int height = 0;
        float density = 0.0f;
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            display.getRealMetrics(metrics);
            width = metrics.widthPixels;
            height = metrics.heightPixels;
            density = metrics.density;
        } else {
            try {
                Method mGetRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                Method mGetRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                width = (Integer)mGetRawW.invoke((Object)display, new Object[0]);
                height = (Integer)mGetRawH.invoke((Object)display, new Object[0]);
                DisplayMetrics metrics = new DisplayMetrics();
                display.getMetrics(metrics);
                density = metrics.density;
            }
            catch (Exception e) {
                Log.d((String)"BitlySDK", (String)"Bitly SDK failed to retrieve screen dimensions", (Throwable)e);
            }
        }
        String[] versions = Build.VERSION.RELEASE.split("\\.");
        String major = versions[0];
        String minor = versions.length > 1 ? versions[1] : "0";
        String patch = versions.length > 2 ? versions[2] : "0";
        Uri.Builder builder = Uri.parse((String)(Bitly.baseUrl() + "v3/mobile/register")).buildUpon().appendQueryParameter("app_id", appId).appendQueryParameter("device_id", deviceId).appendQueryParameter("device_id_type", "android").appendQueryParameter("dsw", String.valueOf(width)).appendQueryParameter("dsh", String.valueOf(height)).appendQueryParameter("dsos", "android").appendQueryParameter("dsosmaj", major).appendQueryParameter("dsosmin", minor).appendQueryParameter("dsosp", patch).appendQueryParameter("dsb", Build.BRAND).appendQueryParameter("dsm", Build.MODEL).appendQueryParameter("dsd", String.valueOf(density));
        if (!this.sharedPreferences.getBoolean("bitly.has.launched", false)) {
            builder.appendQueryParameter("il", "true");
            this.sharedPreferences.edit().putBoolean("bitly.has.launched", true).apply();
        }
        return builder.build();
    }

    final void reset() {
        this.sharedPreferences.edit().putLong("bitly.last.correlation", 0L).apply();
    }

    @Override
    public void onPageStarted() {
        Log.d((String)"BitlySDK", (String)"Bitly SDK correlator started");
    }

    @Override
    public void onPageFinished() {
        Log.d((String)"BitlySDK", (String)"Bitly SDK correlator completed");
        if (this.callback != null) {
            this.callback.onCorrelate(true);
        }
    }

    static interface Callback {
        public void onCorrelate(boolean var1);
    }
}

