/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;
import com.bitly.Bitly;
import com.bitly.Error;
import com.bitly.Response;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONObject;

class Decoder {
    static String baseUrl = "https://bit.ly/api/click";

    Decoder() {
    }

    static void handle(Intent intent) {
        if (intent == null) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid intent found to process");
            return;
        }
        Decoder.handle(Decoder.getLink(intent));
    }

    static void handle(Error error) {
        if (error == null) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid error found to process");
            return;
        }
        Decoder.handle(error.getOriginalUrl());
    }

    private static void handle(final String link) {
        if (TextUtils.isEmpty((CharSequence)link)) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid link found to process");
            return;
        }
        final String bitlink = Bitly.domainSupported(link) ? link : (Bitly.schemeSupported(link) ? Decoder.parseCustomScheme(link) : null);
        if (!TextUtils.isEmpty((CharSequence)bitlink)) {
            new AsyncTask<Void, Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground(Void ... params) {
                    HttpURLConnection connection = null;
                    BufferedReader reader = null;
                    try {
                        String line;
                        connection = (HttpURLConnection)new URL(String.format("%s?app_id=%s&device_id=%s&device_id_type=%s&link=%s", baseUrl, Bitly.currentAppId(), Bitly.currentDeviceId(), "android", URLEncoder.encode(bitlink, "UTF-8"))).openConnection();
                        reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(connection.getInputStream())));
                        StringBuilder result = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            result.append(line);
                        }
                        Response response = new Response(new JSONObject(result.toString()));
                        Log.d((String)"BitlySDK", (String)"Bitly SDK parsing JSON response and calling handler");
                        if (Bitly.currentCallback() != null) {
                            Bitly.currentCallback().onResponse(response);
                        }
                    }
                    catch (Exception e) {
                        Log.d((String)"BitlySDK", (String)("Bitly SDK failed to parse JSON: " + e.getMessage()));
                        if (Bitly.currentCallback() != null) {
                            Bitly.currentCallback().onError(new Error(e.getMessage(), e, link, bitlink));
                        }
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                Log.e((String)"BitlySDK", (String)"Bitly SDK failed to close reader", (Throwable)e);
                            }
                        }
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                    return null;
                }
            }.execute((Object[])new Void[0]);
        } else {
            Log.d((String)"BitlySDK", (String)String.format("Bitly SDK URL %s is not supported by config", link));
        }
    }

    private static String parseCustomScheme(String url) {
        String bitlink = Uri.parse((String)url).getQueryParameter("bitly_bitlink");
        if (!TextUtils.isEmpty((CharSequence)bitlink)) {
            bitlink = "http://" + bitlink;
        }
        return bitlink;
    }

    private static String getLink(Intent intent) {
        if ("android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null) {
            return intent.getData().toString();
        }
        return null;
    }
}

