/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.preference.PreferenceManager;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;

final class Correlator
extends WebViewClient {
    static String LAST_CORRELATION = "lastCorrelation";
    private static long CORRELATION_INTERVAL = 1209600000L;
    private Context context;
    private WebView webView;
    private Callback callback;
    private SharedPreferences sharedPreferences;

    Correlator(Context context) {
        this.context = context;
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    synchronized void correlate(String appId, String deviceId) {
        this.correlate(appId, deviceId, null);
    }

    synchronized void correlate(String appId, String deviceId, Callback callback) {
        this.callback = callback;
        if (System.currentTimeMillis() - this.sharedPreferences.getLong(LAST_CORRELATION, 0L) > CORRELATION_INTERVAL) {
            WebView webView = new WebView(this.context);
            webView.setWebViewClient((WebViewClient)this);
            webView.loadUrl(String.format("https://bit.ly/v3/mobile/register?app_id=%s&device_id=%s&device_id_type=%s", appId, deviceId, "android"));
            this.sharedPreferences.edit().putLong(LAST_CORRELATION, System.currentTimeMillis()).apply();
        } else {
            Log.d((String)"BitlySDK", (String)"Bitly SDK correlator not run");
            if (callback != null) {
                callback.onCorrelate(false);
            }
        }
    }

    void reset() {
        this.sharedPreferences.edit().putLong(LAST_CORRELATION, 0L).apply();
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        Log.d((String)"BitlySDK", (String)"Bitly SDK correlator started");
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        Log.d((String)"BitlySDK", (String)"Bitly SDK correlator completed");
        this.webView = null;
        if (this.callback != null) {
            this.callback.onCorrelate(true);
        }
    }

    static interface Callback {
        public void onCorrelate(boolean var1);
    }
}

