/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.util.Log;
import com.bitly.Correlator;
import com.bitly.Decoder;
import com.bitly.Error;
import com.bitly.Response;
import java.util.ArrayList;
import java.util.List;

public final class Bitly {
    private static Bitly sharedInstance = new Bitly();
    private String appId;
    private String deviceId;
    private List<String> supportedDomains = new ArrayList<String>();
    private List<String> supportedSchemes = new ArrayList<String>();
    private Callback callback;
    private Correlator correlator;

    public static void initialize(@NonNull Context context, @NonNull String appId, @NonNull List<String> supportedDomains, @NonNull List<String> supportedSchemes, Callback callback) {
        Bitly.sharedInstance.appId = appId;
        Bitly.sharedInstance.deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Bitly.sharedInstance.supportedDomains.addAll(supportedDomains);
        Bitly.sharedInstance.supportedSchemes.addAll(supportedSchemes);
        Bitly.sharedInstance.callback = callback;
        Bitly.sharedInstance.correlator = new Correlator(context);
        Bitly.sharedInstance.correlator.correlate(Bitly.sharedInstance.appId, Bitly.sharedInstance.deviceId);
        Log.d((String)"BitlySDK", (String)String.format("Bitly SDK initialized with App ID: %s and Device ID: %s", Bitly.sharedInstance.appId, Bitly.sharedInstance.deviceId));
    }

    public static void reset() {
        Bitly.sharedInstance.appId = null;
        Bitly.sharedInstance.deviceId = null;
        Bitly.sharedInstance.supportedDomains.clear();
        Bitly.sharedInstance.supportedSchemes.clear();
        Bitly.sharedInstance.callback = null;
        if (Bitly.sharedInstance.correlator != null) {
            Bitly.sharedInstance.correlator.reset();
        }
        Bitly.sharedInstance.correlator = null;
        Log.d((String)"BitlySDK", (String)"Bitly SDK reset");
    }

    public static void handleIntent(Intent intent) {
        Decoder.handle(intent);
    }

    public static void retryError(Error error) {
        Decoder.handle(error);
    }

    static String currentAppId() {
        return Bitly.sharedInstance.appId;
    }

    static String currentDeviceId() {
        return Bitly.sharedInstance.deviceId;
    }

    static Callback currentCallback() {
        return Bitly.sharedInstance.callback;
    }

    static boolean domainSupported(@NonNull String url) {
        return Bitly.sharedInstance.supportedDomains.contains(Uri.parse((String)url).getHost());
    }

    static boolean schemeSupported(@NonNull String url) {
        Uri uri = Uri.parse((String)url);
        for (String scheme : Bitly.sharedInstance.supportedSchemes) {
            if (!uri.getScheme().equals(scheme) && (!scheme.contains("://") || !uri.toString().startsWith(scheme))) continue;
            return true;
        }
        return false;
    }

    public static interface Callback {
        public void onResponse(Response var1);

        public void onError(Error var1);
    }
}

