/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.timer;

import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.concurrent.TimeUnit;

public class SystemTimer
implements Timer {
    final long startWallClock;
    final long startNs;

    public SystemTimer() {
        JqLog.d("creating system timer", new Object[0]);
        this.startWallClock = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
        this.startNs = System.nanoTime();
    }

    @Override
    public long nanoTime() {
        return System.nanoTime() - this.startNs + this.startWallClock;
    }

    @Override
    public void waitOnObjectUntilNs(Object object, long untilNs) throws InterruptedException {
        long now = this.nanoTime();
        if (now > untilNs) {
            object.wait(1L);
        } else {
            TimeUnit.NANOSECONDS.timedWait(object, untilNs - now);
        }
    }

    @Override
    public void waitOnObject(Object object) throws InterruptedException {
        object.wait();
    }

    @Override
    public void notifyObject(Object object) {
        object.notifyAll();
    }
}

