/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.messaging;

import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.DelayedMessageBag;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessagePredicate;
import com.birbit.android.jobqueue.messaging.MessageQueue;
import com.birbit.android.jobqueue.messaging.MessageQueueConsumer;
import com.birbit.android.jobqueue.messaging.UnsafeMessageQueue;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.concurrent.atomic.AtomicBoolean;

public class SafeMessageQueue
extends UnsafeMessageQueue
implements MessageQueue {
    private final Object LOCK = new Object();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Timer timer;
    private final DelayedMessageBag delayedBag;
    private boolean postMessageTick = false;
    private final MessageFactory factory;

    public SafeMessageQueue(Timer timer, MessageFactory factory, String logTag) {
        super(factory, logTag);
        this.factory = factory;
        this.timer = timer;
        this.delayedBag = new DelayedMessageBag(factory);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void consume(MessageQueueConsumer consumer) {
        if (this.running.getAndSet(true)) {
            throw new IllegalStateException("only 1 consumer per MQ");
        }
        consumer.onStart();
        while (this.running.get()) {
            Message message = this.next(consumer);
            if (message == null) continue;
            consumer.handleMessage(message);
            this.factory.release(message);
        }
        JqLog.d("[%s] finished queue", this.logTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.running.set(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.timer.notifyObject(this.LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            super.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Message next(MessageQueueConsumer consumer) {
        boolean calledIdle = false;
        while (this.running.get()) {
            Long nextDelayedReadyAt;
            long now;
            Object object = this.LOCK;
            synchronized (object) {
                now = this.timer.nanoTime();
                nextDelayedReadyAt = this.delayedBag.flushReadyMessages(now, this);
                Message message = super.next();
                if (message != null) {
                    return message;
                }
                this.postMessageTick = false;
            }
            if (!calledIdle) {
                consumer.onIdle();
                calledIdle = true;
            }
            object = this.LOCK;
            synchronized (object) {
                if (this.postMessageTick) {
                    continue;
                }
                if (nextDelayedReadyAt != null && nextDelayedReadyAt <= now) {
                    JqLog.d("[%s] next message is ready, requery", this.logTag);
                    continue;
                }
                if (this.running.get()) {
                    try {
                        if (nextDelayedReadyAt == null) {
                            JqLog.d("[%s] will wait on the lock forever", this.logTag);
                            this.timer.waitOnObject(this.LOCK);
                        } else {
                            JqLog.d("[%s] will wait on the lock until %d", this.logTag, nextDelayedReadyAt);
                            this.timer.waitOnObjectUntilNs(this.LOCK, nextDelayedReadyAt);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(Message message) {
        Object object = this.LOCK;
        synchronized (object) {
            this.postMessageTick = true;
            super.post(message);
            this.timer.notifyObject(this.LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postAt(Message message, long readyNs) {
        Object object = this.LOCK;
        synchronized (object) {
            this.postMessageTick = true;
            this.delayedBag.add(message, readyNs);
            this.timer.notifyObject(this.LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelMessages(MessagePredicate predicate) {
        Object object = this.LOCK;
        synchronized (object) {
            super.removeMessages(predicate);
            this.delayedBag.removeMessages(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postAtFront(Message message) {
        Object object = this.LOCK;
        synchronized (object) {
            this.postMessageTick = true;
            super.postAtFront(message);
            this.timer.notifyObject(this.LOCK);
        }
    }
}

