/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class RunningJobSet {
    private ArrayList<String> publicClone;
    private final TreeSet<String> internalSet = new TreeSet();
    private final Map<String, Long> groupDelays = new HashMap<String, Long>();
    private long groupDelayTimeout = Long.MAX_VALUE;
    private final Timer timer;

    public RunningJobSet(Timer timer) {
        this.timer = timer;
    }

    public synchronized void addGroupUntil(String group, long until) {
        JqLog.d("add group delay to %s until %s", group, until);
        Long current = this.groupDelays.get(group);
        if (current != null && current > until) {
            return;
        }
        this.groupDelays.put(group, until);
        this.groupDelayTimeout = this.calculateNextDelayForGroups();
        this.publicClone = null;
    }

    public synchronized Collection<String> getSafe() {
        long now = this.timer.nanoTime();
        if (this.publicClone == null || now > this.groupDelayTimeout) {
            if (this.groupDelays.isEmpty()) {
                this.publicClone = new ArrayList<String>(this.internalSet);
                this.groupDelayTimeout = Long.MAX_VALUE;
            } else {
                TreeSet<String> tmpClone = new TreeSet<String>((SortedSet<String>)this.internalSet);
                Iterator<Map.Entry<String, Long>> itr = this.groupDelays.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<String, Long> entry = itr.next();
                    if (entry.getValue() > now) {
                        if (tmpClone.contains(entry.getKey())) continue;
                        tmpClone.add(entry.getKey());
                        continue;
                    }
                    itr.remove();
                }
                this.publicClone = new ArrayList<String>(tmpClone);
                this.groupDelayTimeout = this.calculateNextDelayForGroups();
            }
        }
        return this.publicClone;
    }

    public Long getNextDelayForGroups() {
        if (this.groupDelayTimeout == Long.MAX_VALUE) {
            return null;
        }
        return this.groupDelayTimeout;
    }

    private long calculateNextDelayForGroups() {
        long result = Long.MAX_VALUE;
        for (Long value : this.groupDelays.values()) {
            if (value >= result) continue;
            result = value;
        }
        return result;
    }

    public synchronized void add(String group) {
        if (group == null) {
            return;
        }
        if (this.internalSet.add(group)) {
            this.publicClone = null;
        }
    }

    public synchronized void remove(String group) {
        if (group == null) {
            return;
        }
        if (this.internalSet.remove(group)) {
            this.publicClone = null;
        }
    }

    public synchronized void clear() {
        this.internalSet.clear();
        this.groupDelays.clear();
        this.publicClone = null;
    }
}

