/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

public class RetryConstraint {
    public static final RetryConstraint RETRY = new ImmutableRetryConstraint(true);
    public static final RetryConstraint CANCEL = new ImmutableRetryConstraint(false);
    private boolean retry;
    private Long newDelayInMs;
    private Integer newPriority;
    private boolean applyNewDelayToGroup = false;

    public RetryConstraint(boolean retry) {
        this.retry = retry;
    }

    public boolean shouldRetry() {
        return this.retry;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
    }

    public Long getNewDelayInMs() {
        return this.newDelayInMs;
    }

    public void setNewDelayInMs(Long newDelayInMs) {
        this.newDelayInMs = newDelayInMs;
    }

    public Integer getNewPriority() {
        return this.newPriority;
    }

    public void setNewPriority(Integer newPriority) {
        this.newPriority = newPriority;
    }

    public static RetryConstraint createExponentialBackoff(int runCount, long initialBackOffInMs) {
        RetryConstraint constraint = new RetryConstraint(true);
        constraint.setNewDelayInMs(initialBackOffInMs * (long)Math.pow(2.0, Math.max(0, runCount - 1)));
        return constraint;
    }

    public void setApplyNewDelayToGroup(boolean applyDelayToGroup) {
        this.applyNewDelayToGroup = applyDelayToGroup;
    }

    public boolean willApplyNewDelayToGroup() {
        return this.applyNewDelayToGroup;
    }

    static class ImmutableRetryConstraint
    extends RetryConstraint {
        private static final String MESSAGE = "This object is immutable. Create a new one using the constructor.";

        public ImmutableRetryConstraint(boolean retry) {
            super(retry);
        }

        @Override
        public void setRetry(boolean retry) {
            throw new IllegalStateException(MESSAGE);
        }

        @Override
        public void setNewDelayInMs(Long newDelayInMs) {
            throw new IllegalStateException(MESSAGE);
        }

        @Override
        public void setNewPriority(Integer newPriority) {
            throw new IllegalStateException(MESSAGE);
        }
    }
}

