/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import android.support.annotation.Nullable;
import java.util.Collections;
import java.util.HashSet;

public class Params {
    public static final long FOREVER = Long.MAX_VALUE;
    public static final long NEVER = Long.MIN_VALUE;
    int requiredNetworkType = 0;
    private String groupId = null;
    private String singleId = null;
    private boolean persistent = false;
    private int priority;
    private long delayMs;
    private HashSet<String> tags;
    private long deadlineMs = 0L;
    private Boolean cancelOnDeadline;

    public Params(int priority) {
        this.priority = priority;
    }

    public Params requireNetwork() {
        if (this.requiredNetworkType != 2) {
            this.requiredNetworkType = 1;
        }
        return this;
    }

    public Params requireUnmeteredNetwork() {
        this.requiredNetworkType = 2;
        return this;
    }

    public Params groupBy(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public Params singleInstanceBy(String singleId) {
        this.singleId = singleId;
        return this;
    }

    public Params persist() {
        this.persistent = true;
        return this;
    }

    public Params delayInMs(long delayMs) {
        this.delayMs = delayMs;
        return this;
    }

    public Params setRequiresNetwork(boolean requiresNetwork) {
        if (requiresNetwork) {
            if (this.requiredNetworkType == 0) {
                this.requiredNetworkType = 1;
            }
        } else {
            this.requiredNetworkType = 0;
        }
        return this;
    }

    public Params setRequiresUnmeteredNetwork(boolean requiresUnmeteredNetwork) {
        if (requiresUnmeteredNetwork) {
            this.requiredNetworkType = 2;
        } else if (this.requiredNetworkType != 1) {
            this.requiredNetworkType = 0;
        }
        return this;
    }

    public Params setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public Params setSingleId(String singleId) {
        this.singleId = singleId;
        return this;
    }

    public Params setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public Params setDelayMs(long delayMs) {
        this.delayMs = delayMs;
        return this;
    }

    public Params addTags(String ... newTags) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        Collections.addAll(this.tags, newTags);
        return this;
    }

    public Params removeTags(String ... oldTags) {
        if (this.tags == null) {
            return this;
        }
        for (String tag : oldTags) {
            this.tags.remove(tag);
        }
        return this;
    }

    public Params clearTags() {
        this.tags = null;
        return this;
    }

    public Params overrideDeadlineToRunInMs(long deadlineInMs) {
        if (Boolean.TRUE.equals(this.cancelOnDeadline)) {
            throw new IllegalArgumentException("cannot set deadline to cancel and run. You need to pick one");
        }
        this.deadlineMs = deadlineInMs;
        this.cancelOnDeadline = false;
        return this;
    }

    public Params overrideDeadlineToCancelInMs(long deadlineInMs) {
        if (Boolean.FALSE.equals(this.cancelOnDeadline)) {
            throw new IllegalArgumentException("cannot set deadline to cancel and run. You need to pick one");
        }
        this.deadlineMs = deadlineInMs;
        this.cancelOnDeadline = true;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getSingleId() {
        return this.singleId;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getDelayMs() {
        return this.delayMs;
    }

    public long getDeadlineMs() {
        return this.deadlineMs;
    }

    @Nullable
    public Boolean getCancelOnDeadline() {
        return this.cancelOnDeadline;
    }

    public HashSet<String> getTags() {
        return this.tags;
    }

    public boolean shouldCancelOnDeadline() {
        return Boolean.TRUE.equals(this.cancelOnDeadline);
    }

    public boolean isNetworkRequired() {
        return this.requiredNetworkType >= 1;
    }

    public boolean isUnmeteredNetworkRequired() {
        return this.requiredNetworkType >= 2;
    }
}

