/*
 * Decompiled with CFR 0.152.
 */
package com.billy.android.preloader;

import android.text.TextUtils;
import com.billy.android.preloader.IWorker;
import com.billy.android.preloader.PreLoader;
import com.billy.android.preloader.Worker;
import com.billy.android.preloader.interfaces.DataListener;
import com.billy.android.preloader.interfaces.GroupedDataListener;
import com.billy.android.preloader.interfaces.GroupedDataLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;

class WorkerGroup
implements IWorker {
    private Collection<Worker> workers;

    WorkerGroup(GroupedDataLoader[] loaders) {
        if (loaders != null) {
            HashMap map = new HashMap(loaders.length);
            for (GroupedDataLoader loader : loaders) {
                Worker old;
                String key = loader.keyInGroup();
                if (TextUtils.isEmpty((CharSequence)key)) {
                    PreLoader.logger.warning("GroupedDataLoader with no key:" + loader.getClass().getName());
                }
                if ((old = map.put(key, new Worker(loader, (DataListener)null))) == null) continue;
                PreLoader.logger.error("More than 1 loaders with same key:(" + loader.getClass().getName() + ", " + old.getClass().getName() + "). " + old.getClass().getName() + " will be skipped.");
            }
            this.workers = map.values();
        } else {
            this.workers = new ArrayList<Worker>();
        }
    }

    @Override
    public void setThreadPoolExecutor(ExecutorService threadPoolExecutor) {
        for (Worker worker : this.workers) {
            worker.setThreadPoolExecutor(threadPoolExecutor);
        }
    }

    @Override
    public boolean preLoad() {
        boolean success = true;
        for (Worker worker : this.workers) {
            success &= worker.preLoad();
        }
        return success;
    }

    @Override
    public boolean refresh() {
        boolean success = true;
        for (Worker worker : this.workers) {
            success &= worker.refresh();
        }
        return success;
    }

    @Override
    public boolean listenData(DataListener dataListener) {
        boolean success = true;
        String key = null;
        if (dataListener != null && dataListener instanceof GroupedDataListener) {
            key = ((GroupedDataListener)dataListener).keyInGroup();
        }
        for (Worker worker : this.workers) {
            GroupedDataLoader loader;
            if (TextUtils.isEmpty((CharSequence)key) || !(worker.dataLoader instanceof GroupedDataLoader) || !key.equals((loader = (GroupedDataLoader)worker.dataLoader).keyInGroup())) continue;
            success &= worker.listenData(dataListener);
        }
        return success;
    }

    @Override
    public boolean listenData() {
        boolean success = true;
        for (Worker worker : this.workers) {
            success &= worker.listenData();
        }
        return success;
    }

    @Override
    public boolean removeListener(DataListener listener) {
        boolean success = true;
        for (Worker worker : this.workers) {
            success &= worker.removeListener(listener);
        }
        return success;
    }

    @Override
    public boolean destroy() {
        boolean success = true;
        for (Worker worker : this.workers) {
            success &= worker.destroy();
        }
        this.workers.clear();
        return success;
    }
}

