/*
 * Decompiled with CFR 0.152.
 */
package com.billy.android.preloader;

import android.os.Handler;
import android.os.Looper;
import com.billy.android.preloader.PreLoader;
import com.billy.android.preloader.State;
import com.billy.android.preloader.StateDestroyed;
import com.billy.android.preloader.StateDone;
import com.billy.android.preloader.StateListening;
import com.billy.android.preloader.StateLoadCompleted;
import com.billy.android.preloader.StateLoading;
import com.billy.android.preloader.StatusInitialed;
import com.billy.android.preloader.interfaces.DataListener;
import com.billy.android.preloader.interfaces.DataLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class Worker<T>
implements Runnable {
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("pre-loader-pool-" + thread.getId());
            return thread;
        }
    };
    private static ExecutorService defaultThreadPoolExecutor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), FACTORY);
    private ExecutorService threadPoolExecutor;
    private T loadedData;
    private final List<DataListener<T>> dataListeners = new CopyOnWriteArrayList<DataListener<T>>();
    private DataLoader<T> dataLoader;
    private volatile State state;

    Worker(DataLoader<T> loader, DataListener<T> listener) {
        this.init(loader);
        if (listener != null) {
            this.dataListeners.add(listener);
        }
    }

    Worker(DataLoader<T> loader, List<DataListener<T>> listeners) {
        this.init(loader);
        if (listeners != null) {
            this.dataListeners.addAll(listeners);
        }
    }

    private void init(DataLoader<T> loader) {
        this.dataLoader = loader;
        this.setState(new StatusInitialed(this));
    }

    static void setDefaultThreadPoolExecutor(ExecutorService threadPoolExecutor) {
        if (threadPoolExecutor != null) {
            defaultThreadPoolExecutor = threadPoolExecutor;
        }
    }

    void setThreadPoolExecutor(ExecutorService threadPoolExecutor) {
        if (threadPoolExecutor != null) {
            this.threadPoolExecutor = threadPoolExecutor;
        }
    }

    boolean preLoad() {
        return this.state.startLoad();
    }

    boolean doStartLoadWork() {
        if (this.threadPoolExecutor != null) {
            this.threadPoolExecutor.execute(this);
        } else {
            defaultThreadPoolExecutor.execute(this);
        }
        this.setState(new StateLoading(this));
        return true;
    }

    boolean refresh() {
        return this.state.refresh();
    }

    boolean listenData(DataListener<T> dataListener) {
        if (dataListener != null) {
            this.dataListeners.add(dataListener);
            return this.state.listenData(dataListener);
        }
        return false;
    }

    boolean listenData() {
        return this.state.listenData();
    }

    boolean doDataLoadFinishWork() {
        this.setState(new StateLoadCompleted(this));
        return true;
    }

    boolean doSendLoadedDataToListenerWork() {
        return this.doSendLoadedDataToListenerWork(this.dataListeners);
    }

    boolean doSendLoadedDataToListenerWork(DataListener<T> listener) {
        ArrayList<DataListener<T>> listeners = new ArrayList<DataListener<T>>(1);
        listeners.add(listener);
        return this.doSendLoadedDataToListenerWork(listeners);
    }

    private boolean doSendLoadedDataToListenerWork(final List<DataListener<T>> listeners) {
        if (!(this.state instanceof StateDone)) {
            this.setState(new StateDone(this));
        }
        if (!listeners.isEmpty()) {
            if (this.isMainThread()) {
                this.safeListenData(listeners, this.loadedData);
            } else {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        Worker.this.safeListenData(listeners, Worker.this.loadedData);
                    }
                });
            }
            return true;
        }
        return false;
    }

    boolean doWaitForDataLoaderWork() {
        if (this.dataListeners.isEmpty()) {
            return false;
        }
        this.setState(new StateListening(this));
        return true;
    }

    boolean destroy() {
        return this.state.destroy();
    }

    boolean doDestroyWork() {
        this.setState(new StateDestroyed(this));
        this.dataListeners.clear();
        this.dataLoader = null;
        this.threadPoolExecutor = null;
        return true;
    }

    @Override
    public void run() {
        try {
            this.loadedData = this.dataLoader.loadData();
        }
        catch (Exception e) {
            PreLoader.logger.throwable(e);
        }
        this.state.dataLoadFinished();
    }

    private void safeListenData(List<DataListener<T>> listeners, T t) {
        for (DataListener<T> listener : listeners) {
            try {
                listener.onDataArrived(t);
            }
            catch (Exception e) {
                PreLoader.logger.throwable(e);
            }
        }
    }

    private boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    private void setState(State state) {
        if (state != null) {
            this.state = state;
            PreLoader.logger.info("set state to:" + state.name());
        }
    }
}

