/*
 * Decompiled with CFR 0.152.
 */
package com.billy.android.preloader;

import com.billy.android.preloader.PreLoader;
import com.billy.android.preloader.Worker;
import com.billy.android.preloader.interfaces.DataListener;
import com.billy.android.preloader.interfaces.DataLoader;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PreLoaderPool {
    private final AtomicInteger idMaker = new AtomicInteger(0);
    private final ConcurrentHashMap<Integer, Worker> workerMap = new ConcurrentHashMap();

    public static PreLoaderPool getDefault() {
        return Inner.INSTANCE;
    }

    public <T> int preLoad(DataLoader<T> loader) {
        Worker<T> worker = new Worker<T>(loader, (DataListener)null);
        return this.preLoadWorker(worker);
    }

    public <T> int preLoad(DataLoader<T> loader, DataListener<T> listener) {
        Worker<T> worker = new Worker<T>(loader, listener);
        return this.preLoadWorker(worker);
    }

    public <T> int preLoad(DataLoader<T> loader, List<DataListener<T>> listeners) {
        Worker<T> worker = new Worker<T>(loader, listeners);
        return this.preLoadWorker(worker);
    }

    private <T> int preLoadWorker(Worker<T> worker) {
        int id = this.idMaker.incrementAndGet();
        this.workerMap.put(id, worker);
        worker.preLoad();
        return id;
    }

    public boolean listenData(int id) {
        Worker worker = this.workerMap.get(id);
        return worker != null && worker.listenData();
    }

    public <T> boolean listenData(int id, DataListener<T> dataListener) {
        try {
            Worker worker = this.workerMap.get(id);
            return worker != null && worker.listenData(dataListener);
        }
        catch (Exception e) {
            PreLoader.logger.throwable(e);
            return false;
        }
    }

    public boolean refresh(int id) {
        Worker worker = this.workerMap.get(id);
        return worker != null && worker.refresh();
    }

    public boolean destroy(int id) {
        Worker worker = this.workerMap.remove(id);
        return worker != null && worker.destroy();
    }

    public boolean destroyAll() {
        for (Worker worker : this.workerMap.values()) {
            if (worker == null) continue;
            try {
                worker.destroy();
            }
            catch (Exception e) {
                PreLoader.logger.throwable(e);
            }
        }
        this.workerMap.clear();
        this.idMaker.set(0);
        return true;
    }

    private static class Inner {
        static final PreLoaderPool INSTANCE = new PreLoaderPool();

        private Inner() {
        }
    }
}

